@extends($activeTemplate . 'layouts.master')
@section('content')
    <div class="card custom--card">
        <div class="card-header">
            <h5 class="card-title mb-0">@lang('Withdraw Via') {{ $withdraw->method->name }}</h5>
        </div>
        <div class="card-body">
            <div class="alert-item-wrapper">
                <div class="alert-item mb-4">
                    <div class="alert flex-align alert--primary" role="alert">
                        <span class="alert__icon"><i class="las la-info-circle"></i></span>
                        <div class="alert__content">
                            <p class="alert__desc">
                                @lang('You are requesting')
                                <b>{{ showAmount($withdraw->amount) }}</b> @lang('for withdraw.') @lang('The admin will send you')
                                <b class="text--success">{{ showAmount($withdraw->final_amount, currencyFormat: false) . ' ' . $withdraw->currency }}
                                </b> @lang('to your account.')
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <form action="{{ route('user.withdraw.submit') }}" class="disableSubmission" method="post"
                  enctype="multipart/form-data">
                @csrf
                <div class="mb-2">
                    @php
                        echo $withdraw->method->description;
                    @endphp
                </div>
                <x-viser-form identifier="id" identifierValue="{{ $withdraw->method->form_id }}" />
                @if (auth()->user()->ts)
                    <div class="form-group">
                        <label class="form-label">@lang('Google Authenticator Code')</label>
                        <div class="form--control-wrapper">
                            <input type="text" name="authenticator_code" class="form--control" required>
                        </div>
                    </div>
                @endif
                <div class="form-group">
                    <button type="submit" class="btn btn--base w-100">@lang('Submit')</button>
                </div>
            </form>
        </div>
    </div>
@endsection
