@extends($activeTemplate . 'layouts.master')
@section('content')
    <div class="show-filter mb-3 text-end">
        <button type="button" class="btn btn--base showFilterBtn btn-sm"><i class="las la-filter"></i> @lang('Filter')</button>
    </div>
    <div class="card custom--card mb-4 responsive-filter-card">
        <div class="card-body">
            <form class="filter-form" action="">
                <div class="row gy-3">
                    <div class="col-xsm-6 col-sm-6 col-md-4 col-lg-3">
                        <label class="form-label">@lang('Transaction Number')</label>
                        <div class="form--control-wrapper">
                            <input type="search" name="search" value="{{ request()->search }}" class="form--control">
                        </div>
                    </div>
                    <div class="col-xsm-6 col-sm-6 col-md-4 col-lg-3">
                        <label class="form-label d-block">@lang('Type')</label>
                        <div class="form--select2-wrapper">
                            <span class="form--select2-wrapper__shapes"></span>
                            <select name="trx_type" class="form--select form--control select2"
                                    data-minimum-results-for-search="-1">
                                <option value="">@lang('All')</option>
                                <option value="+" @selected(request()->trx_type == '+')>@lang('Plus')</option>
                                <option value="-" @selected(request()->trx_type == '-')>@lang('Minus')</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4 col-lg-4">
                        <label class="form-label d-block">@lang('Remark')</label>
                        <div class="form--select2-wrapper">
                            <span class="form--select2-wrapper__shapes"></span>
                            <select class="form--select form--control select2" data-minimum-results-for-search="1"
                                    name="remark">
                                <option value="">@lang('All')</option>
                                @foreach ($remarks as $remark)
                                    <option value="{{ $remark->remark }}" @selected(request()->remark == $remark->remark)>
                                        {{ __(keyToTitle($remark->remark)) }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-lg-2 align-self-end">
                        <button class="btn btn--lg btn--base w-100 text-nowrap">
                            <i class="las la-filter"></i>
                            @lang('Filter')
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    @if (!blank($transactions))
        <div class="table-responsive">
            <table class="table custom--table table--responsive--lg">
                <thead>
                    <tr>
                        <th>@lang('Trx')</th>
                        <th>@lang('Transacted')</th>
                        <th>@lang('Amount')</th>
                        <th>@lang('Post Balance')</th>
                        <th>@lang('Detail')</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($transactions as $trx)
                        <tr>
                            <td>
                                <strong>{{ $trx->trx }}</strong>
                            </td>

                            <td>
                                {{ showDateTime($trx->created_at) }}<br>{{ diffForHumans($trx->created_at) }}
                            </td>

                            <td>
                                <span
                                      class="fw-bold @if ($trx->trx_type == '+') text--success @else text--danger @endif">
                                    {{ $trx->trx_type }} {{ showAmount($trx->amount) }}
                                </span>
                            </td>

                            <td>
                                {{ showAmount($trx->post_balance) }}
                            </td>


                            <td>{{ __($trx->details) }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    @else
        <div class="card custom--card">
            <div class="card-body">
                @include($activeTemplate . 'partials.empty', ['message' => 'Transaction not found'])
            </div>
        </div>
    @endif

    @if ($transactions->hasPages())
        <div class="pagination-wrapper">
            {{ paginateLinks($transactions) }}
        </div>
    @endif
@endsection
