@extends($activeTemplate . 'layouts.' . $layout)
@section('content')

    @guest
        <section class="contact-section py-60 position-relative">
            <span class="contact-section__light"></span>
            <div class="container">
            @endguest

            <div class="row gy-4">
                <div class="col-lg-8">
                    <div class="card custom--card">
                        <div class="card-header card-header-bg">
                            <div class="d-flex flex-wrap justify-content-between align-items-center gap-2">
                                <h5 class="text-white mb-0">{{ $myTicket->subject }}</h5>
                            </div>
                        </div>
                        <div class="card-body">
                            <form method="post" class="disableSubmission"
                                action="{{ route('ticket.reply', $myTicket->id) }}" enctype="multipart/form-data">
                                @csrf
                                <div class="row gy-4">
                                    <div class="col-md-12">
                                        <div class="form--control-wrapper form--control-wrapper-textarea">
                                            <textarea name="message" class="form--control" placeholder="Your message..." required>{{ old('message') }}</textarea>
                                        </div>
                                    </div>
                                    <div class="col-lg-12">
                                        <button class="btn btn--base btn--sm addAttachment" type="button">
                                            <i class="fas fa-plus"></i>
                                            @lang('Add Attachment')
                                        </button>
                                        <p class="fs-14 text--base mt-2 mb-4 d-flex align-items-start gap-2">
                                            <i class="fas fa-exclamation-circle mt-1"></i>
                                            @lang('Max 5 files can be uploaded | Maximum upload size is ' . convertToReadableSize(ini_get('upload_max_filesize')) . ' | Allowed File Extensions: .jpg, .jpeg, .png, .pdf, .doc, .docx')
                                        </p>
                                        <div class="row gy-3 fileUploadsContainer">
                                        </div>
                                    </div>
                                    <div class="col-lg-12">
                                        <div class="text-end">
                                            <button class="btn btn--base" type="submit">
                                                <i class="la la-fw la-lg la-reply"></i>
                                                @lang('Reply')
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>

                    <div class="card custom--card mt-4">
                        <div class="card-header">
                            <h5 class="text-white mb-0">@lang('Chat Converertion') </h5>
                        </div>
                        <div class="card-body">
                            @forelse($messages as $message)
                                @if ($message->admin_id == 0)
                                    <div class="chat-box chat-box--user">
                                        <div class="chat-box__header">
                                            <h6 class="chat-box__name">{{ $message->ticket->name }}</h6>
                                            <p class="chat-box__date">
                                                @lang('Posted on')
                                                {{ showDateTime($message->created_at, 'l, dS F Y @ h:i a') }}
                                            </p>
                                        </div>
                                        <div class="chat-box__body">
                                            <p class="chat-box__text">{{ $message->message }}</p>
                                            @if ($message->attachments->count() > 0)
                                                <div class="chat-box__attachments">
                                                    @foreach ($message->attachments as $k => $image)
                                                        <a href="{{ route('ticket.download', encrypt($image->id)) }}">
                                                            <i class="fa-regular fa-file"></i>
                                                            @lang('Attachment')
                                                            {{ ++$k }}
                                                        </a>
                                                    @endforeach
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                @else
                                    <div class="chat-box chat-box--admin">
                                        <div class="chat-box__header">
                                            <h6 class="chat-box__name">{{ $message->admin->name }}</h6>
                                            <p class="chat-box__date">
                                                @lang('Posted on')
                                                {{ showDateTime($message->created_at, 'l, dS F Y @ h:i a') }}
                                            </p>
                                        </div>
                                        <div class="chat-box__body">
                                            <p class="chat-box__text">{{ $message->message }}</p>
                                            @if ($message->attachments->count() > 0)
                                                <div class="chat-box__attachments">
                                                    @foreach ($message->attachments as $k => $image)
                                                        <a href="{{ route('ticket.download', encrypt($image->id)) }}">
                                                            <i class="fa-regular fa-file"></i>
                                                            @lang('Attachment')
                                                            {{ ++$k }}
                                                        </a>
                                                    @endforeach
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                @endif
                            @empty
                                <div class="empty-message text-center">
                                    <img src="{{ getImage('assets/images/empty_list.png') }}" alt="empty">
                                    <h5 class="text-muted">@lang('No replies found here!')</h5>
                                </div>
                            @endforelse
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="card custom--card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">@lang('Ticket Information')</h5>
                        </div>
                        <div class="card-body">
                            <ul class="ticket-info-list">
                                <li class="ticket-info-list__item">
                                    <span class="label">@lang('Ticket ID:')</span>
                                    <span class="value">#{{ $myTicket->ticket }}</span>
                                </li>
                                <li class="ticket-info-list__item">
                                    <span class="label">@lang('Status:')</span>
                                    @php echo $myTicket->statusBadge; @endphp
                                </li>
                                <li class="ticket-info-list__item">
                                    <span class="label">@lang('Priority:')</span>
                                    @if ($myTicket->priority == Status::PRIORITY_LOW)
                                        <span class="badge badge--info">@lang('Low')</span>
                                    @elseif($myTicket->priority == Status::PRIORITY_MEDIUM)
                                        <span class="badge  badge--warning">@lang('Medium')</span>
                                    @elseif($myTicket->priority == Status::PRIORITY_HIGH)
                                        <span class="badge badge--danger">@lang('High')</span>
                                    @endif
                                </li>
                                <li class="ticket-info-list__item">
                                    <span class="label">@lang('Opened At:')</span>
                                    <span class="value">{{ showDateTime($myTicket->created_at) }}</span>
                                </li>
                                <li class="ticket-info-list__item">
                                    <span class="label">@lang('Last Reply:')</span>
                                    <span class="value">{{ showDateTime($myTicket->last_reply) }}</span>
                                </li>
                            </ul>

                            @if ($myTicket->status != Status::TICKET_CLOSE && $myTicket->user)
                                <button class="btn btn--danger close-button confirmationBtn mt-3 w-100" type="button"
                                    data-question="@lang('Are you sure to close this ticket?')"
                                    data-action="{{ route('ticket.close', $myTicket->id) }}">
                                    <i class="las la-times"></i>
                                    @lang('Close Support')
                                </button>
                            @endif
                        </div>
                    </div>
                </div>
            </div>

            @guest
            </div>
        </section>
    @endguest
@endsection

@section('modal')
    <x-confirmation-modal isFrontend=true />
@endsection

@push('style')
    <style>
        .input-group-text:focus {
            box-shadow: none !important;
        }

        .reply-bg {
            background-color: #ffd96729
        }

        .empty-message img {
            width: 120px;
            margin-bottom: 15px;
        }

        .input-group-text.removeFile {
            padding: 0;
            color: hsl(var(--danger));
        }

        @media screen and (max-width: 1399px) {
            .close-button {
                padding: 16px 24px;
                font-size: 0.875rem;
            }
        }
    </style>
@endpush
@push('script')
    <script>
        (function($) {
            "use strict";
            var fileAdded = 0;
            $('.addAttachment').on('click', function() {
                fileAdded++;
                if (fileAdded == 5) {
                    $(this).attr('disabled', true)
                }
                $(".fileUploadsContainer").append(`
                    <div class="col-sm-6 removeFileInput">
                        <div class="form--control-wrapper">
                            <input type="file" name="attachments[]" class="form--control" accept=".jpeg,.jpg,.png,.pdf,.doc,.docx">
                            <button type="button" class="input-group-text removeFile bg--danger border--danger"><i class="fas fa-times"></i></button>
                        </div>
                    </div>
                `);
            });
            $(document).on('click', '.removeFile', function() {
                $('.addAttachment').removeAttr('disabled', true)
                fileAdded--;
                $(this).closest('.removeFileInput').remove();
            });
        })(jQuery);
    </script>
@endpush
