@extends($activeTemplate . 'layouts.master')
@section('content')
    <div class="card custom--card">
        <div class="card-body">
            <form action="{{ route('ticket.store') }}" class="disableSubmission" method="post" enctype="multipart/form-data">
                @csrf
                <div class="row gy-4">
                    <div class="col-md-6">
                        <label class="form-label">@lang('Subject')</label>
                        <div class="form--control-wrapper">
                            <input type="text" name="subject" value="{{ old('subject') }}"
                                   class="form-control form--control" required>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">@lang('Priority')</label>
                        <div class="form--select2-wrapper">
                            <span class="form--select2-wrapper__shapes"></span>
                            <select name="priority" class="form-select form--control select2"
                                    data-minimum-results-for-search="-1" required>
                                <option value="3">@lang('High')</option>
                                <option value="2">@lang('Medium')</option>
                                <option value="1">@lang('Low')</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-12">
                        <label class="form-label">@lang('Message')</label>
                        <div class="form--control-wrapper form--control-wrapper-textarea">
                            <textarea name="message" id="inputMessage" rows="6" class="form-control form--control" required>{{ old('message') }}</textarea>
                        </div>
                    </div>

                    <div class="col-lg-12">
                        <button class="btn btn--base btn--sm addAttachment" type="button">
                            <i class="fas fa-plus"></i>
                            @lang('Add Attachment')
                        </button>
                        <p class="fs-14 text--base mt-2 mb-4 d-flex align-items-start gap-2">
                            <i class="fas fa-exclamation-circle mt-1"></i>
                            @lang('Max 5 files can be uploaded | Maximum upload size is ' . convertToReadableSize(ini_get('upload_max_filesize')) . ' | Allowed File Extensions: .jpg, .jpeg, .png, .pdf, .doc, .docx')
                        </p>
                        <div class="row gy-3 fileUploadsContainer">
                        </div>
                    </div>
                    <div class="col-lg-12">
                        <div class="text-end">
                            <button class="btn btn--base" type="submit">
                                <i class="la la-fw la-lg la-reply"></i>
                                @lang('Reply')
                            </button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection

@push('style')
    <style>
        .input-group-text:focus {
            box-shadow: none !important;
        }

        .input-group-text.removeFile {
            padding: 0;
            color: hsl(var(--danger));
        }
    </style>
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";
            var fileAdded = 0;
            $('.addAttachment').on('click', function() {
                fileAdded++;
                if (fileAdded == 5) {
                    $(this).attr('disabled', true)
                }
                $(".fileUploadsContainer").append(`
                    <div class="col-lg-4 col-md-6 removeFileInput">
                        <div class="form--control-wrapper">
                            <input type="file" name="attachments[]" class="form--control" accept=".jpeg,.jpg,.png,.pdf,.doc,.docx" required>
                            <button type="button" class="input-group-text removeFile bg--danger border--danger"><i class="fas fa-times"></i></button>
                        </div>
                    </div>
                `)
            });
            $(document).on('click', '.removeFile', function() {
                $('.addAttachment').removeAttr('disabled', true)
                fileAdded--;
                $(this).closest('.removeFileInput').remove();
            });
        })(jQuery);
    </script>
@endpush
