@extends($activeTemplate . 'layouts.master')

@section('content')
    @if (!blank($investments))
        <form class="search-form w-sm-50 ms-auto mb-3">
            <div class="form--control-wrapper">
                <input type="search" name="search" class="form--control" value="{{ request()->search }}"
                       placeholder="@lang('Search by transactions')">
                <button class="input-group-text bg-primary text-white">
                    <i class="las la-search"></i>
                </button>
            </div>
        </form>
        <div class="table-responsive">
            <table class="table custom--table table--responsive--lg">
                <thead>
                    <tr>
                        <th>@lang('Method | Transaction')</th>
                        <th>@lang('Initial Deposit')</th>
                        <th>@lang('Contribution Amount')</th>
                        <th>@lang('Total Return')</th>
                        <th>@lang('Invested At')</th>
                        <th>@lang('Status')</th>
                        <th class="text-nowrap">@lang('Action')</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($investments as $investment)
                        <tr>
                            <td>
                                <div>
                                    <span class="fw-bold">
                                        <span class="text-primary">
                                            {{ $investment->payment_method == Status::WALLET_INVEST ? 'Wallet' : ($investment->payment_method == Status::GATEWAY_INVEST ? 'Gateway' : ($investment->payment_method == Status::MANUAL_GATEWAY ? 'Manual' : 'Unknown')) }}
                                        </span>
                                    </span>
                                    <br>
                                    <small>{{ $investment->trx }}</small>
                                </div>
                            </td>


                            <td class="text-center">
                                {{ showAmount($investment->initial_deposit) }}
                            </td>

                            <td>
                                {{ showAmount($investment->contribution_amount) }}
                            </td>

                            <td>
                                {{ showAmount($investment->total_return) }}
                            </td>

                            <td class="text-end text-lg-center">
                                {{ showDateTime($investment->created_at) }} <br>
                                {{ diffForHumans($investment->created_at) }}
                            </td>

                            <td class="text-center">
                                @php echo $investment->investStatusBadge @endphp
                            </td>
                            <td>
                                <div class="dropdown more--dropdown">
                                    <button class="dropdown-toggle" type="button" data-bs-toggle="dropdown"
                                            aria-haspopup="true" aria-expanded="false">
                                        <i class="fas fa-ellipsis-vertical"></i>
                                    </button>
                                    <div class="dropdown-menu dropdown-menu-right" aria-labelledby="navbarDropdown">
                                        <a class="dropdown-item"
                                           href="{{ route('user.investment.details', $investment->id) }}">
                                            @lang('Investment Details')
                                        </a>
                                        @if (gs('investment_early_closure'))
                                            @if (in_array($investment->status, [Status::INVESTMENT_COMPLETE, Status::INVESTMENT_CLOSED, Status::INVESTMENT_INITIATE]))
                                                <a href="javascript:void(0)"
                                                   class="dropdown-item disabled">
                                                    @lang('Close Investment')
                                                </a>
                                            @else
                                                <a href="javascript:void(0)"
                                                   data-action="{{ route('user.investment.close', ['investment' => $investment->id]) }}"
                                                   data-question="@lang('Are you sure you want to close this investment?')"
                                                   class="dropdown-item confirmationBtn">
                                                    @lang('Close Investment')
                                                </a>
                                            @endif
                                        @endif
                                    </div>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    @else
        <div class="card custom--card">
            <div class="card-body">
                @php
                    $message = isset($scope) ? ucfirst($scope) . ' investment not found !' : 'All investment not found';
                @endphp
                @include($activeTemplate . 'partials.empty', ['message' => $message])
            </div>
        </div>
    @endif

    @if ($investments->hasPages())
        <div class="pagination-wrapper">
            {{ paginateLinks($investments) }}
        </div>
    @endif
@endsection

@section('modal')
    <x-confirmation-modal :isFrontend="true" />
@endsection

@push('style')
    <style>
        .more--dropdown .dropdown-toggle {
            --size: 28px;
            width: var(--size);
            height: var(--size);
            border-radius: 50%;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            color: hsl(var(--white)/0.8);
            font-size: calc(var(--size) * 0.5);
            border: 1px solid hsl(var(--white)/0.1);
            background-color: hsl(var(--white)/0.1);
            transition: .2s linear;
        }

        .more--dropdown .dropdown-toggle:hover,
        .more--dropdown .dropdown-toggle:focus {
            outline: none;
            border-color: hsl(var(--base));
            background-color: hsl(var(--base));
        }

        .more--dropdown .dropdown-toggle::after {
            display: none;
        }

        .more--dropdown .dropdown-item {
            padding: 8px 12px;
            color: hsl(var(--white) / 0.6);
        }

        .more--dropdown .dropdown-item:hover,
        .more--dropdown .dropdown-item:focus {
            color: hsl(var(--white));
            outline: none;
            background-color: hsl(var(--base));
        }

        .more--dropdown .dropdown-item.disabled {
            color: hsl(var(--white) / 0.5);
            pointer-events: none;
        }

        .more--dropdown .dropdown-menu {
            padding: 0px;
            overflow: hidden;
            background-color: hsl(var(--common-bg));
            border: 1px solid hsl(var(--white) /0.2);
            border-radius: 6px !important;
        }

        @media screen and (max-width: 991px) {
            .more--dropdown .dropdown-menu {
                min-width: 200px;
            }

            .more--dropdown .dropdown-toggle {
                --size: 24px;
                transform: rotate(90deg);
            }
        }

        .table thead tr th {
            font-size: 0.875rem;
        }

        .table tbody tr td,
        .table tbody tr td::before {
            font-size: 0.875rem !important;
        }
    </style>
@endpush
