@extends($activeTemplate . 'layouts.master')

@section('content')
    @php
        $kyc = getContent('kyc.content', true);
        $user = auth()->user();
    @endphp
    <div class="notice"></div>
    <div class="alert-item-wrapper">
        @if ($user->kv == Status::KYC_UNVERIFIED && $user->kyc_rejection_reason)
            <div class="alert-item mb-4">
                <div class="alert flex-align align-items-start alert--danger" role="alert">
                    <span class="alert__icon"><i class="las la-exclamation-circle"></i></span>
                    <div class="alert__content">
                        <div class="d-flex flex-wrap justify-content-between align-items-center mb-2">
                            <span class="alert__title fs-16">@lang('KYC Documents Rejected')</span>
                            <button class="btn btn-outline--base btn--sm" data-bs-toggle="modal"
                                    data-bs-target="#kycRejectionReason">@lang('Show Reason')</button>
                        </div>
                        <p class="mb-0">{{ __($kyc?->data_values?->reject) }} <a
                               href="{{ route('user.kyc.form') }}">@lang('Click Here to Re-submit Documents')</a>.</p>
                        <a href="{{ route('user.kyc.data') }}">@lang('See KYC Data')</a>
                    </div>
                </div>
            </div>
        @elseif($user->kv == Status::KYC_UNVERIFIED)
            <div class="alert-item mb-4">
                <div class="alert flex-align align-items-start alert--info" role="alert">
                    <span class="alert__icon"><i class="las la-exclamation-circle"></i></span>
                    <div class="alert__content">
                        <span class="alert__title fs-16">@lang('KYC Verification required')</span>
                        <p class="mb-0">{{ __($kyc?->data_values?->required) }} <a
                               href="{{ route('user.kyc.form') }}">@lang('Click Here to Submit Documents')</a></p>
                    </div>
                </div>
            </div>
        @elseif($user->kv == Status::KYC_PENDING)
            <div class="alert-item mb-4">
                <div class="alert flex-align align-items-start alert--warning" role="alert">
                    <span class="alert__icon"><i class="lar la-check-circle"></i></span>
                    <div class="alert__content">
                        <span class="alert__title fs-16">@lang('KYC Verification pending')</span>
                        <p class="mb-0">{{ __($kyc?->data_values?->pending) }} <a
                               href="{{ route('user.kyc.data') }}">@lang('See KYC Data')</a></p>
                    </div>
                </div>
            </div>
        @endif
    </div>
    <div class="row gy-4 justify-content-center">
        <div class="col-12">
            <!-- Dashboard Card Start -->
            <div class="row gy-4 justify-content-center dashboard-widget-wrapper">
                <div class="col-xl-4 col-lg-4 col-sm-6">
                    <a href="{{ route('user.transactions') }}" class="dashboard-widget flex-align">
                        <div class="dashboard-widget__icon flex-center">
                            <i class="las la-dollar-sign"></i>
                        </div>
                        <div class="dashboard-widget__content">
                            <span class="dashboard-widget__text">@lang('Balance')</span>
                            <h4 class="dashboard-widget__number">{{ showAmount($user->balance) }}</h4>
                        </div>
                    </a>
                </div>
                <div class="col-xl-4 col-lg-4 col-sm-6">
                    <a href="{{ route('user.investment.all') }}" class="dashboard-widget flex-align">
                        <div class="dashboard-widget__icon flex-center">
                            <i class="fas fa-coins"></i>
                        </div>
                        <div class="dashboard-widget__content">
                            <span class="dashboard-widget__text">@lang('Total Investment')</span>
                            <h4 class="dashboard-widget__number">{{ $totalInvestments }}</h4>
                        </div>
                    </a>
                </div>
                <div class="col-xl-4 col-lg-4 col-sm-6">
                    <a href="{{ route('user.investment.contributions') }}" class="dashboard-widget flex-align">
                        <div class="dashboard-widget__icon flex-center">
                            <i class="fas fa-chart-area"></i>
                        </div>
                        <div class="dashboard-widget__content">
                            <span class="dashboard-widget__text"> @lang('Total Contribution') </span>
                            <h4 class="dashboard-widget__number">{{ showAmount($totalContributionAmount) }}</h4>
                        </div>
                    </a>
                </div>
                <div class="col-xl-4 col-lg-4 col-sm-6">
                    <a href="{{ route('user.deposit.history') }}" class="dashboard-widget flex-align">
                        <div class="dashboard-widget__icon flex-center">
                            <i class="fas fa-file-invoice-dollar"></i>
                        </div>
                        <div class="dashboard-widget__content">
                            <span class="dashboard-widget__text">@lang('Total Deposit')</span>
                            <h4 class="dashboard-widget__number">{{ showAmount($totalDeposit) }}</h4>
                        </div>
                    </a>
                </div>
                <div class="col-xl-4 col-lg-4 col-sm-6">
                    <a href="{{ route('user.withdraw.history') }}" class="dashboard-widget flex-align">
                        <div class="dashboard-widget__icon flex-center">
                            <i class="las la-cloud-download-alt"></i>
                        </div>
                        <div class="dashboard-widget__content">
                            <span class="dashboard-widget__text">@lang('Total Withdraw')</span>
                            <h4 class="dashboard-widget__number">{{ showAmount($totalWithdraw) }}</h4>
                        </div>
                    </a>
                </div>
                <div class="col-xl-4 col-lg-4 col-sm-6">
                    <a href="{{ route('user.transactions') }}?remark=referral_commission"
                       class="dashboard-widget flex-align">
                        <div class="dashboard-widget__icon flex-center">
                            <i class="fas fa-wallet"></i>
                        </div>
                        <div class="dashboard-widget__content">
                            <span class="dashboard-widget__text">@lang('Referral Earning')</span>
                            <h4 class="dashboard-widget__number">{{ showAmount($referralEarnings) }}</h4>
                        </div>
                    </a>
                </div>
            </div>
            <!-- Dashboard Card End -->
        </div>
    </div>
    <div class="dashboard-table mt-4">
        <h5 class="title mb-3">@lang('Latest Transactions')</h5>
        @if (!blank($transactions))
            <table class="table table--responsive--lg">
                <thead>
                    <tr>
                        <th class="text-start">@lang('Date')</th>
                        <th class="text-center">@lang('Transaction ID')</th>
                        <th class="text-center">@lang('Amount')</th>
                        <th class="text-end">@lang('Post Balance')</th>
                        <th class="text-center">@lang('Details')</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($transactions as $trx)
                        <tr>
                            <td class="text-start">
                                {{ showDatetime($trx->created_at, 'Y-m-d h:i A') }}
                            </td>
                            <td><span class="text-primary">{{ $trx->trx }}</span></td>

                            <td class="text-end text-lg-center">
                                @if ($trx->trx_type == '+')
                                    <span class="text-success">+
                                        {{ showAmount($trx->amount) }}</span>
                                @else
                                    <span class="text-danger">-
                                        {{ showAmount($trx->amount) }}</span>
                                @endif
                            </td>
                            <td class="text-end text-lg-center">
                                <span>{{ showAmount($trx->post_balance) }}</span>
                            </td>
                            <td class="text-end">{{ $trx->details }}</td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="100%" class="text-center">
                                @lang('No Transaction Found')
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        @else
            <div class="card custom--card">
                <div class="card-body">
                    @include($activeTemplate . 'partials.empty', ['message' => 'Transaction not found'])
                </div>
            </div>
        @endif
    </div>
@endsection

@section('modal')
    @if ($user->kv == Status::KYC_UNVERIFIED && $user->kyc_rejection_reason)
        <div class="modal custom--modal fade" id="kycRejectionReason">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">@lang('KYC Document Rejection Reason')</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <p>{{ $user->kyc_rejection_reason }}</p>
                    </div>
                </div>
            </div>
        </div>
    @endif
@endsection
