@extends($activeTemplate . 'layouts.frontend')
@section('content')
    @php
        $registerContent = getContent('register.content', true);
    @endphp
    <section class="account-section py-120 position-relative">
        <span class="account-section__light position-absolute"></span>
        @if (gs('registration'))
            <div class="container">
                <div class="row gy-4">
                    <div class="col-lg-6">
                        <div class="account-section__items">
                            <form action="{{ route('user.register') }}" method="POST"
                                  class="verify-gcaptcha disableSubmission">
                                @csrf
                                @include($activeTemplate . 'partials.social_login')
                                <div class="row gy-3">
                                    @if (session()->get('reference') != null)
                                        <div class="col-lg-12 col-md-12">
                                            <div class="form-group">
                                                <label class="form--label">@lang('Reference by')</label>
                                                <div class="form--control-wrapper">
                                                    <input type="text" name="referBy" class="form--control" value="{{ session()->get('reference') }}" readonly>
                                                </div>
                                            </div>
                                        </div>
                                    @endif

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form--label">@lang('First Name')</label>
                                            <div class="form--control-wrapper">
                                                <input type="text" class="form--control" name="firstname"
                                                       value="{{ old('firstname') }}" required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form--label">@lang('Last Name')</label>
                                            <div class="form--control-wrapper">
                                                <input type="text" class="form--control" name="lastname"
                                                       value="{{ old('lastname') }}" required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label class="form--label">@lang('E-mail Address')</label>
                                            <div class="form--control-wrapper">
                                                <input type="email" class="form--control checkUser" name="email"
                                                       value="{{ old('email') }}" required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form--label">@lang('Password')</label>
                                            <div class="form--control-wrapper">
                                                <input type="password"
                                                       class="form--control @if (gs('secure_password')) secure-password @endif"
                                                       name="password" required>
                                                <span
                                                      class="password-show-hide fas toggle-password fa-eye-slash"></span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form--label">@lang('Confirm Password')</label>
                                            <div class="form--control-wrapper">
                                                <input type="password" class="form--control"
                                                       name="password_confirmation" required>
                                                <span
                                                      class="password-show-hide fas toggle-password fa-eye-slash"></span>
                                            </div>
                                        </div>
                                    </div>

                                    <x-captcha isFrontend="true" />

                                    @if (gs('agree'))
                                        @php
                                            $policyPages = getContent('policy_pages.element', false, orderById: true);
                                        @endphp
                                        <div class="col-12">
                                            <div class="form-check form--check d-flex">
                                                <input class="form-check-input" type="checkbox"
                                                       @checked(old('agree')) name="agree" id="agree"
                                                       required>
                                                <div class="form-check-label">
                                                    <label class="check-text" for="agree">@lang('I agree with')
                                                        @foreach ($policyPages as $policy)
                                                            <a class="chack-text"
                                                               href="{{ route('policy.pages', $policy->slug) }}"
                                                               target="_blank">
                                                                {{ __($policy->data_values->title) }}
                                                                @if (!$loop->last)
                                                                    ,
                                                                @endif
                                                            </a>
                                                        @endforeach
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    @endif
                                    <div class="col-12">
                                        <div class="my-4">
                                            <button class="btn btn--base" type="submit">@lang('Register')</button>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="create-account d-flex gap-2">
                                            <p class="create-account_content">@lang('Already Have An Account ?')</p>
                                            <a class="create-account_account" href="{{ route('user.login') }}">
                                                @lang('Login Now')</a>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="register-image">
                            <img src="{{ frontendImage('register', $registerContent->data_values->image ?? null, '640x860') }}"
                                 alt="@lang('login')">
                        </div>
                    </div>
                </div>
            </div>
        @else
            @include($activeTemplate . 'partials.registration_disabled')
        @endif
    </section>

    <div class="modal custom--modal fade" id="existModalCenter" tabindex="-1" role="dialog"
         aria-labelledby="existModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="existModalLongTitle">@lang('You are with us')</h5>
                    <span type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </span>
                </div>
                <div class="modal-body">
                    <p class="text-center mb-0">@lang('You already have an account please Login ')</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-dark btn--sm"
                            data-bs-dismiss="modal">@lang('Close')</button>
                    <a href="{{ route('user.login') }}" class="btn btn--base btn--sm">@lang('Login')</a>
                </div>
            </div>
        </div>
    </div>
@endsection

@if (gs('registration'))

    @push('style')
        <style>
            .social-login-btn {
                border: 1px solid #cbc4c4;
            }
        </style>
    @endpush

    @if (gs('secure_password'))
        @push('script-lib')
            <script src="{{ asset('assets/global/js/secure_password.js') }}"></script>
        @endpush
    @endif

    @push('script')
        <script>
            "use strict";
            (function($) {

                $('.checkUser').on('focusout', function(e) {
                    var url = '{{ route('user.checkUser') }}';
                    var value = $(this).val();
                    var token = '{{ csrf_token() }}';

                    var data = {
                        email: value,
                        _token: token
                    }

                    $.post(url, data, function(response) {
                        if (response.data != false) {
                            $('#existModalCenter').modal('show');
                        }
                    });
                });
            })(jQuery);
        </script>
    @endpush

@endif

@push('style')
    <style>
        .hover-input-popup .input-popup {
            background-color: #2f2f2f !important;
        }

        .input-popup::after {
            border-color: transparent transparent #2f2f2f transparent !important;
        }
    </style>
@endpush
