@extends($activeTemplate . 'layouts.frontend')
@section('content')
    <div class="container py-100">
        <div class="row justify-content-center">
            <div class="col-md-8 col-lg-7 col-xl-5">
                <div class="card custom--card">
                    <div class="card-body">
                        <div class="mb-4">
                            <p>@lang('Your account is verified successfully. Now you can change your password. Please enter a strong password and don\'t share it with anyone.')</p>
                        </div>
                        <form method="POST" action="{{ route('user.password.update') }}">
                            @csrf
                            <input type="hidden" name="email" value="{{ $email }}">
                            <input type="hidden" name="token" value="{{ $token }}">
                            <div class="form-group">
                                <label class="form-label">@lang('Password')</label>
                                <div class="form--control-wrapper">
                                    <input type="password" class="form-control form--control @if (gs('secure_password')) secure-password @endif" name="password" required>
                                    <span class="password-show-hide fas toggle-password fa-eye-slash"></span>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="form-label">@lang('Confirm Password')</label>
                                <div class="form--control-wrapper">
                                    <input type="password" class="form-control form--control" name="password_confirmation" required>
                                    <span class="password-show-hide fas toggle-password fa-eye-slash"></span>
                                </div>
                            </div>
                            <div class="form-group mb-0">
                                <button type="submit" class="btn btn--base w-100"> @lang('Submit')</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@if (gs('secure_password'))
    @push('script-lib')
        <script src="{{ asset('assets/global/js/secure_password.js') }}"></script>
    @endpush
@endif


@push('style')
    <style>
        .hover-input-popup .input-popup {
            background-color: #2f2f2f !important;
        }

        .input-popup::after {
            border-color: transparent transparent #2f2f2f transparent !important;
        }
    </style>
@endpush
