@extends($activeTemplate . 'layouts.frontend')
@section('content')
    @php
        $loginContent = getContent('login.content', true);
    @endphp
    <section class="account-section py-120 position-relative">
        <span class="account-section__light"></span>
        <div class="container">
            <form method="POST" action="{{ route('user.login') }}" class="verify-gcaptcha">
                @csrf
                <div class="row gy-4">
                    <div class="col-lg-6">
                        <div class="account-section__items">

                            @include($activeTemplate . 'partials.social_login')

                            <div class="form-group">
                                <label class="form--label">@lang('Username or Email')</label>
                                <div class="form--control-wrapper">
                                    <input type="text" name="username" value="{{ old('username') }}" class="form--control" required>
                                </div>
                            </div>

                            <div class="form-group">
                                <label class="form--label">@lang('Password')</label>
                                <div class="form--control-wrapper">
                                    <input type="password" name="password" id="password" class="form--control" required>
                                    <span class="password-show-hide fas toggle-password fa-eye-slash"></span>
                                </div>
                            </div>

                            <x-captcha isFrontend="true" />

                            <div class="form-check form--check d-flex align-items-center ">
                                <input class="form-check-input" type="checkbox" name="remember" id="remember" {{ old('remember') ? 'checked' : '' }}>
                                <div class="form-check-label d-flex align-items-center">
                                    <label class="check-text" for="remember">@lang('Remember me')</label>
                                    <div class="forgot"><a href="{{ route('user.password.request') }}">@lang('Forgot Password?')</a></div>
                                </div>
                            </div>
                            <div class="my-4">
                                <button type="submit" id="recaptcha" class="btn btn--base">@lang('LOGIN')</button>
                            </div>
                            @if (gs('registration'))
                                <div class="create-account d-flex gap-2">
                                    <p class="create-account_content">@lang('Don\'t Have An Account?')</p>
                                    <a class="create-account_account" href="{{ route('user.register') }}">@lang('Create Account')</a>
                                </div>
                            @endif
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="login-image">
                            <img src="{{ frontendImage('login', $loginContent->data_values->image ?? null, '640x860') }}" alt="@lang('login')">
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </section>
@endsection
