@php
    $testimonialContent = getContent('testimonial.content', true);
    $testimonialElements = getContent('testimonial.element', orderById: true);
@endphp

<section class="testimonial py-100 bg-img"
    data-background-image="{{ frontendImage('testimonial', $testimonialContent->data_values->background_image ?? '', '1905x870') }}">
    <div class="testimonial__light one"></div>
    <div class="testimonial__light two"></div>
    <div class="container">
        <div class="section-heading wow fadeIn" data-wow-duration="0.5s" data-wow-delay="0.3s">
            <h2 class="section-heading__title wow fadeInUp" data-wow-duration="0.5s" data-highlight="-1,-2">
                {{ __($testimonialContent->data_values?->title ?? '') }}</h2>
            <p class="section-heading__desc wow fadeInUp" data-wow-duration="0.5s">
                {{ __($testimonialContent->data_values?->subtitle ?? '') }}</p>
        </div>
        <div class="testimonial-slider wow fadeInUp" data-wow-duration="0.5s" data-wow-delay="0.3s">
            @foreach ($testimonialElements as $testimonialElement)
                <div class="testimonial-slider__slide">
                    <div class="testimonial-card">
                        <div class="testimonial-card__header">
                            <div class="testimonial-card-user">
                                <img class="testimonial-card-user__thumb"
                                    src="{{ frontendImage('testimonial', $testimonialElement->data_values?->user_image ?? '', '80x80') }}"
                                    alt="@lang('user')">
                                <div class="testimonial-card-user__content">
                                    <h3 class="testimonial-card-user__name">
                                        {{ $testimonialElement->data_values?->name ?? '' }}</h3>
                                    <span
                                        class="testimonial-card-user__username">{{ $testimonialElement->data_values?->username ?? '' }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="testimonial-card__body">
                            <p class="testimonial-card__desc">
                                {{ __($testimonialElement->data_values?->description ?? '') }}</p>
                        </div>
                        <div class="testimonial-card__footer">
                            <ul class="testimonial-card-info">
                                <li class="testimonial-card-info__item">
                                    <div class="testimonial-card__position">
                                        {{ __($testimonialElement->data_values?->designation ?? '') }}</div>
                                </li>
                                <li class="testimonial-card-info__item">
                                    <img class="testimonial-card__logo"
                                        src="{{ frontendImage('testimonial', $testimonialElement->data_values?->company_logo ?? '', '25x25') }}"
                                        alt="@lang('logo')">
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>
