@php
    $blogContent = getContent('blog.content', true);
    $blogs = getContent('blog.element', limit: 3);
@endphp

<section class="blog py-100">
    <div class="blog-light"></div>
    <div class="blog-coins">
        <span class="blog-coins__coin-one"><img src="{{ getImage($activeTemplateTrue . 'images/coin/blog1.png') }}" alt="@lang('blog1')"></span>
        <span class="blog-coins__coin-twe"><img src="{{ getImage($activeTemplateTrue . 'images/coin/blog2.png') }}" alt="@lang('blog2')"></span>
        <span class="blog-coins__coin-three"><img src="{{ getImage($activeTemplateTrue . 'images/coin/blog3.png') }}" alt="@lang('blog3')"></span>
    </div>

    <div class="container">
        <div class="flex-between gap-3 mb-60 align-items-start">
            <div class="section-heading style-left mb-0 wow fadeInLeft">
                <h2 class="section-heading__title" data-highlight="-1">{{ __($blogContent->data_values?->heading ?? '') }}</h2>
                <p class="section-heading__desc text">{{ __($blogContent->data_values?->subheading ?? '') }}</p>
            </div>
            <div class="see-more-btn wow fadeInRight">
                <a class="btn btn-outline--base" href="{{ route('blog') }}">@lang('See More')</a>
            </div>
        </div>
        @include($activeTemplate . 'partials.blog_items')
    </div>
</section>
