@php
    $affiliateContent = getContent('affiliate_program.content', true);
    $affiliateElements = getContent('affiliate_program.element', orderById: true, limit: 5);
@endphp
<section class="program-section py-100">
    <div class="container">
        <div class="row flex-wrap-reverse gy-4">
            <div class="col-lg-6">
                <div class="section-heading style-left wow fadeIn" data-wow-duration="0.5s" data-wow-delay="0.3s">
                    <h2 class="section-heading__title wow fadeInUp" data-wow-duration="0.5s" data-wow-delay="0.3s" data-highlight="-2_-1">{{ __($affiliateContent->data_values?->title ?? '') }}</h2>
                    <p class="section-heading__desc text-start text-msm-center wow fadeInUp" data-wow-duration="0.5s" data-wow-delay="0.3s">{{ __($affiliateContent->data_values?->subtitle ?? '') }}</p>
                </div>
                <div class="program-items wow fadeInRight">
                    @foreach ($affiliateElements as $index => $affiliateElement)
                        <div class="program-items__content">
                            <img class="program-items__image" src="{{ frontendImage('affiliate_program', $affiliateElement->data_values?->level_image ?? '', '150x150') }}" alt="@lang('program-img')">
                            <p class="program-items__para">
                                <span>{{ __($affiliateElement->data_values?->level_name ?? '') }}:</span>
                                {{ __($affiliateElement->data_values?->level_description ?? '') }}
                            </p>
                        </div>
                    @endforeach
                </div>
            </div>
            <div class="col-lg-6">
                <img class="program-items__thum__image wow fadeInRight" data-wow-duration="0.5s" data-wow-delay="0.3s" src="{{ frontendImage('affiliate_program', $affiliateContent->data_values?->image ?? '', '510x685') }}" alt="@lang('coin')">
            </div>
        </div>
    </div>
</section>
