@php
    $aboutContent = getContent('about.content', true);
    $aboutElements = getContent('about.element', orderById: true, limit: 4);
@endphp
<section class="about-section py-100 bg-img"
         data-background-image="{{ frontendImage('about', $aboutContent->data_values?->background_image ?? '', '1905x735') }}">
    <div class="container">
        <div class="row gy-4 align-items-center">
            <div class="col-xl-6">
                <div class="about-section-thumb wow fadeIn" data-wow-duration="0.5s" data-wow-delay="0.3s">
                    <img class="about-section-thumb__main" src="{{ frontendImage('about', $aboutContent->data_values?->main_image ?? '', '640x485') }}" alt="@lang('main_image')">
                    <img class="about-section-thumb__coin one" src="{{ getImage($activeTemplateTrue . 'images/coin/about-coin1.png') }}" alt="@lang('coin')">
                    <img class="about-section-thumb__coin two" src="{{ getImage($activeTemplateTrue . 'images/coin/about-coin2.png') }}" alt="@lang('coin')">
                    <img class="about-section-thumb__coin three" src="{{ getImage($activeTemplateTrue . 'images/coin/about-coin3.png') }}" alt="@lang('coin')">
                    <img class="about-section-thumb__coin four" src="{{ getImage($activeTemplateTrue . 'images/coin/about-coin4.png') }}" alt="@lang('coin')">
                </div>
            </div>
            <div class="col-xl-6">
                <div class="about-section-content">
                    <div class="section-heading style-left wow fadeIn" data-wow-duration="0.5s" data-wow-delay="0.3s">
                        <h2 class="section-heading__title wow fadeInDown" data-wow-duration="0.5s" data-wow-delay="0.3s" data-highlight="-1">{{ __($aboutContent->data_values?->title ?? '') }}</h2>
                        <p class="section-heading__desc wow fadeInDown" data-wow-duration="0.5s" data-wow-delay="0.3s">{{ __($aboutContent->data_values?->description ?? '') }}</p>
                    </div>
                    <div class="row gy-4">
                        @foreach ($aboutElements as $aboutElement)
                            <div class="col-xsm-6 col-sm-6">
                                <div class="about-section-info wow fadeIn" data-wow-duration="0.5s" data-wow-delay="0.3s">
                                    <h3 class="about-section-info__title wow fadeInUp" data-wow-duration="0.5s" data-wow-delay="0.3s">
                                        <span class="about-section-info__icon mask-img wow fadeInUp" data-wow-duration="0.5s" data-wow-delay="0.3s" data-mask-image="{{ frontendImage('about', $aboutElement->data_values?->image ?? '', '38x38') }}"></span>
                                        {{ __($aboutElement->data_values?->title ?? '') }}
                                    </h3>
                                    <p class="about-section-info__desc wow fadeInUp" data-wow-duration="0.5s" data-wow-delay="0.3s">{{ __($aboutElement->data_values?->description ?? '') }}</p>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
