<div class="row justify-content-between">
    <div class="col-lg-5">
        @if (!request()->routeIs('user.investment.now'))
            <div class="wow fadeInLeft" data-wow-duration="0.5s" data-wow-delay="0.3s">
        @endif
        <form id="investmentMainForm" action="{{ route('user.investment.create') }}" method="POST">
            @csrf
            <div class="form--group mb-4">
                <label class="form--label">@lang('INITIAL DEPOSIT')</label>
                <div class="form--control-wrapper">
                    <input type="number" class="form--control" name="initial_deposit" id="initial_deposit"
                           value="1000" placeholder="@lang('Initial deposit amount') ({{ gs('cur_sym') }})" required>
                </div>
            </div>

            <div class="form--group mb-4">
                <label class="form--label">@lang('CONTRIBUTIONS')</label>
                <div class="form--control-wrapper">
                    <input type="number" class="form--control" name="contribution_amount" id="contribution_amount"
                           value="100" placeholder="@lang('Contribution amount') ({{ gs('cur_sym') }})" required>
                </div>

            </div>

            <label class="form--label">@lang('CONTRIBUTION FREQUENCY')</label>
            <div class="form-radio">
                <div class="radio-option">
                    <div class="form--radio">
                        <input type="radio" class="form-check-input" name="contribution_frequency"
                               id="daily_frequency" value="{{ Status::DAILY_FREQUENCY }}">
                        <label class="form-check-label" for="daily_frequency">@lang('Daily')</label>
                    </div>
                    <div class="form--radio">
                        <input type="radio" class="form-check-input" name="contribution_frequency"
                               id="weekly_frequency" value="{{ Status::WEEKLY_FREQUENCY }}">
                        <label class="form-check-label" for="weekly_frequency">@lang('Weekly')</label>
                    </div>
                </div>

                <div class="radio-option">
                    <div class="form--radio">
                        <input type="radio" class="form-check-input" name="contribution_frequency"
                               id="monthly_frequency" value="{{ Status::MONTHLY_FREQUENCY }}" checked>
                        <label class="form-check-label" for="monthly_frequency">@lang('Monthly')</label>
                    </div>
                    <div class="form--radio">
                        <input type="radio" class="form-check-input" name="contribution_frequency"
                               id="annually_frequency" value="{{ Status::ANNUALLY_FREQUENCY }}">
                        <label class="form-check-label" for="annually_frequency">@lang('Annually')</label>
                    </div>
                </div>
            </div>


            <label class="form--label">@lang('YEARS TO GROW')</label>
            <div class="price-range d-flex mb-3">
                <span class="text-white price-range__title" id="max_price">
                    {{ getAmount(gs('investment_minimum_year')) }} @lang('years')
                </span>
            </div>
            <div id="slider-range"></div>

            <!-- Hidden input to store the selected years -->
            <input type="hidden" name="duration_years" id="duration_years"
                   value="{{ getAmount(gs('investment_minimum_year')) }}">

            <div class="form--group mb-4 mt-4">
                <label class="form--label">@lang('AVERAGE ANNUAL RETURN')</label>
                <div class="form--control-wrapper">
                    <input type="text" class="form--control" id="annual_return_rate"
                           value="{{ getAmount(gs('annual_return_rate')) }}%" readonly>
                </div>
            </div>
            <div class="d-flex gap-2  {{ !request()->routeIs('user.investment.now') ? 'flex-wrap' : '' }}">
                <div class="calculate-btn mb-2">
                    <button type="button"
                            class="btn btn--base submit {{ request()->routeIs('user.investment.now') ? 'btn--sm' : '' }}"
                            data-bs-toggle="modal" data-bs-target="#paymentMethodModal">
                        @lang('Invest Now')
                    </button>
                </div>
                <div class="calculate-btn">
                    <button type="button"
                            class="btn btn--base submit {{ request()->routeIs('user.investment.now') ? 'btn--sm' : '' }}"
                            id="calculate-btn">
                        @lang('Calculate Estimate')
                    </button>
                </div>
            </div>
        </form>
        @if (!request()->routeIs('user.investment.now'))
    </div>
    @endif
</div>
<div class="col-lg-7">
    @if (!request()->routeIs('user.investment.now'))
        <div class="calculate-item wow fadeInRight" data-wow-duration="0.5s" data-wow-delay="0.3s">
        @else
            <div class="calculate-item">
    @endif
    <div class="calculate-item__content">
        <h3 class="calculate-item__subtitle">@lang('Potential Future Balance:')</h3>
        <h2 class="calculate-item__title" id="result">{{ gs('cur_sym') }}0</h2>
    </div>
    <div id="calculate" class="potential-chart">
    </div>
</div>
</div>
</div>

@section('modal')
    <div class="custom--modal modal fade" id="paymentMethodModal" tabindex="-1"
         aria-labelledby="paymentMethodModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="paymentMethodModalLabel">@lang('Select Payment Method')</h5>
                    <button type="button" class="btn-close close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <div id="investmentSummary" class="investment-summary text-center text-white fw-bold fs-6">
                        <!-- Populated dynamically -->
                    </div>

                    <div class="investment-payment-options">
                        <label class="custom-checkbox" for="payFromBalance">
                            <input class="d-none" type="radio" name="payment_method"
                                   value="{{ Status::WALLET_INVEST }}" id="payFromBalance" checked>
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                 fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                 stroke-linejoin="round" class="lucide lucide-wallet-icon lucide-wallet">
                                <path
                                      d="M19 7V4a1 1 0 0 0-1-1H5a2 2 0 0 0 0 4h15a1 1 0 0 1 1 1v4h-3a2 2 0 0 0 0 4h3a1 1 0 0 0 1-1v-2a1 1 0 0 0-1-1" />
                                <path d="M3 5v14a2 2 0 0 0 2 2h15a1 1 0 0 0 1-1v-4" />
                            </svg>
                            @lang('From Balance')
                        </label>
                        <label class="custom-checkbox" for="payViaGateway">
                            <input class="d-none" type="radio" name="payment_method"
                                   value="{{ Status::GATEWAY_INVEST }}" id="payViaGateway">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 50 50" width="24" height="24"
                                 fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                 stroke-linejoin="round" class="lucide lucide-landmark-icon lucide-landmark">
                                <path
                                      d="M 5 7 C 2.25 7 0 9.25 0 12 L 0 38 C 0 40.75 2.25 43 5 43 L 45 43 C 47.75 43 50 40.75 50 38 L 50 12 C 50 9.25 47.75 7 45 7 Z M 5 9 L 45 9 C 46.667969 9 48 10.332031 48 12 L 48 38 C 48 39.667969 46.667969 41 45 41 L 5 41 C 3.332031 41 2 39.667969 2 38 L 2 12 C 2 10.332031 3.332031 9 5 9 Z M 29.6875 19.40625 C 26.585938 19.40625 25 20.933594 25 22.875 C 25 26.386719 29.0625 25.914063 29.0625 27.71875 C 29.0625 28.023438 28.828125 28.75 27.125 28.75 C 25.417969 28.75 24.3125 28.09375 24.3125 28.09375 L 23.78125 30.46875 C 23.78125 30.46875 24.886719 31.09375 27 31.09375 C 29.113281 31.09375 32.03125 29.476563 32.03125 27.125 C 32.03125 24.296875 27.96875 24.074219 27.96875 22.8125 C 27.96875 22.167969 28.46875 21.6875 29.9375 21.6875 C 30.890625 21.6875 31.96875 22.40625 31.96875 22.40625 L 32.46875 19.96875 C 32.46875 19.96875 31.050781 19.40625 29.6875 19.40625 Z M 16.46875 19.625 L 13.78125 27.5625 C 13.78125 27.5625 13.597656 26.886719 13.53125 26.46875 C 11.996094 23.023438 9.5 21.75 9.5 21.75 L 11.875 30.75 L 15.125 30.75 L 19.625 19.625 Z M 20.78125 19.625 L 19.03125 30.75 L 22 30.75 L 23.78125 19.625 Z M 36.8125 19.625 L 31.96875 30.75 L 34.90625 30.75 L 35.5 29.15625 L 39.1875 29.15625 L 39.5 30.75 L 42.1875 30.75 L 39.90625 19.625 Z M 6.25 19.65625 C 6.25 19.65625 12.054688 21.453125 13.40625 25.8125 L 12.40625 20.75 C 12.40625 20.75 11.976563 19.65625 10.8125 19.65625 Z M 37.9375 22.84375 L 38.75 27.03125 L 36.3125 27.03125 Z" />
                            </svg>
                            @lang('Via Gateway')
                        </label>
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="w-100 btn btn--base" id="confirmInvestment">@lang('Confirm')</button>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('style')
    <style>
        .investment-payment-options {
            display: flex;
            flex-wrap: wrap;
            align-items: center;
            gap: 24px;
        }

        .investment-payment-options .custom-checkbox {
            flex-grow: 1;
        }

        .investment-summary:not(:last-child) {
            margin-bottom: 32px
        }

        @media screen and (max-width: 575px) {
            .investment-summary:not(:last-child) {
                margin-bottom: 24px
            }
        }

        .investment-summary p {
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .investment-summary p:not(:last-child) {
            border-bottom: 1px solid hsl(var(--white) / 0.15);
            padding-bottom: 8px;
            margin-bottom: 8px;
        }

        .investment-summary p strong {
            color: hsl(var(--body-color));
            font-weight: 500;
        }

        .investment-summary p span {
            color: hsl(var(--white));
        }
    </style>
@endpush

@push('script-lib')
    <!-- apexcharts js -->
    <script src="{{ asset($activeTemplateTrue . 'js/apexcharts.min.js') }}"></script>
@endpush

@push('script')
    <script>
        "use strict";
        (function($) {
            $('#confirmInvestment').off('click').on('click', function() {
                let selectedMethod = $('input[name="payment_method"]:checked');

                if (selectedMethod.length === 0) {
                    notify('error', "Please select a payment method");
                    return;
                }

                let form = $('#investmentMainForm');
                $('<input>').attr({
                    type: 'hidden',
                    name: 'payment_method',
                    value: selectedMethod.val()
                }).appendTo(form);

                form.submit();
            });

            let minYear = parseInt("{{ getAmount(gs('investment_minimum_year')) }}");
            let maxYear = parseInt("{{ getAmount(gs('investment_maximum_year')) }}");
            let defaultYear = maxYear;
            let type = "year";

            $("#duration_years").val(defaultYear);
            $("#max_price").text(defaultYear + " " + type + (defaultYear > 1 ? "s" : ""));

            $("#slider-range").slider({
                range: "min",
                min: minYear,
                max: maxYear,
                value: maxYear,
                slide: function(event, ui) {
                    $("#max_price").text(ui.value + " " + type + (ui.value > 1 ? "s" : ""));
                    $("#duration_years").val(ui.value);
                }
            });

            $("#calculate-btn").on("click", function() {
                let annualRate = parseFloat("{{ gs('annual_return_rate') }}");
                let initialDeposit = parseFloat($("#initial_deposit").val()) || 0;
                let contributionAmount = parseFloat($("#contribution_amount").val()) || 0;
                let annualInterestRate = parseFloat(annualRate) / 100 || 0;
                let compoundingFrequency = getInterestFrequencyFactor($(
                    'input[name="contribution_frequency"]:checked').val());
                let investmentYears = parseFloat($("#duration_years").val()) || 0;

                if (investmentYears <= 0) {
                    notify("error", "Please enter a valid duration in years.");
                    return;
                }

                let yearLabels = [];
                let cumulativeInvestments = [];
                let investmentReturns = [];

                let totalContributed = initialDeposit;
                let currentBalance = initialDeposit;

                const currentYear = new Date().getFullYear();

                yearLabels.push(currentYear);
                cumulativeInvestments.push(totalContributed);
                investmentReturns.push(0);

                for (let year = 1; year <= investmentYears; year++) {
                    const nextYear = currentYear + year;
                    yearLabels.push(nextYear);

                    const yearlyContribution = contributionAmount * compoundingFrequency;
                    totalContributed += yearlyContribution;

                    const growthFactor = Math.pow(1 + annualInterestRate / compoundingFrequency,
                        compoundingFrequency);
                    const existingBalanceGrowth = currentBalance * growthFactor;

                    let contributionGrowth = 0;
                    if (annualInterestRate > 0) {
                        const ratePerPeriod = annualInterestRate / compoundingFrequency;
                        const futureValueFactor = (growthFactor - 1) / ratePerPeriod;
                        contributionGrowth = contributionAmount * futureValueFactor;
                    } else {
                        contributionGrowth = yearlyContribution;
                    }

                    currentBalance = existingBalanceGrowth + contributionGrowth;
                    const investmentProfit = currentBalance - totalContributed;

                    cumulativeInvestments.push(totalContributed);
                    investmentReturns.push(investmentProfit);
                    $("#result").text("{{ gs('cur_sym') }}" + currentBalance.toFixed(2));
                }

                chart.updateOptions({
                    xaxis: {
                        categories: yearLabels,
                    },
                });

                chart.updateSeries([{
                        name: "Total Contributions",
                        data: cumulativeInvestments,
                    },
                    {
                        name: "Investment Returns",
                        data: investmentReturns,
                    },
                ]);
            });

            function getInterestFrequencyFactor(frequency) {
                switch (parseInt(frequency)) {
                    case 1:
                        return 365;
                    case 2:
                        return 52;
                    case 3:
                        return 12;
                    case 4:
                        return 1;
                    default:
                        return 1;
                }
            }

            // ApexCharts Configuration
            const investmentColor = '#{{ gs('base_color') ?? 'ff0000' }}';
            const returnColor = '#{{ gs('secondary_color' ?? 'ffffff') }}';
            const curSym = '{{ gs('cur_sym') }}';

            var options = {
                series: [{
                        name: "Investment",
                        data: [],
                    },
                    {
                        name: "Return",
                        data: [],
                    },
                ],
                chart: {
                    type: "bar",
                    height: 350,
                    stacked: true,
                    toolbar: {
                        show: true,
                        tools: {
                            download: false,
                        },
                    },
                },
                colors: [investmentColor, returnColor],
                plotOptions: {
                    bar: {
                        horizontal: false,
                        columnWidth: "60%",
                    },
                },
                dataLabels: {
                    enabled: false,
                },
                xaxis: {
                    categories: [],
                    labels: {
                        style: {
                            colors: "#ffffff",
                        },
                    },
                },
                yaxis: {
                    labels: {
                        formatter: function(val) {
                            return "$" + val.toLocaleString();
                        },
                        style: {
                            colors: "#ffffff",
                        },
                    },
                },
                legend: {
                    position: "top",
                    labels: {
                        colors: "#ffffff",
                    },
                    markers: {
                        fillColors: [investmentColor, returnColor],
                    },
                },
                fill: {
                    opacity: 1,
                },
                tooltip: {
                    shared: true,
                    intersect: false,
                    theme: "dark",
                    custom: function({
                        series,
                        seriesIndex,
                        dataPointIndex,
                        w
                    }) {
                        const investment = series[0][dataPointIndex];
                        const returnAmount = series[1][dataPointIndex];

                        return `
                            <div class="apexcharts-tooltip-custom">
                                <span style="color: ${returnColor}">●</span> Return: ${curSym}${returnAmount.toLocaleString()}<br />
                                <span style="color: ${investmentColor}">●</span> Contribution: ${curSym}${investment.toLocaleString()}
                            </div>
                        `;
                    },
                },
            };

            var chart = new ApexCharts(document.querySelector("#calculate"), options);
            chart.render();
            $("#calculate-btn").trigger("click");

            $('#paymentMethodModal').on('show.bs.modal', function() {
                const summary = $('#investmentSummary');
                const deposit = parseFloat($('#initial_deposit').val()) || 0;
                const contribution = parseFloat($('#contribution_amount').val()) || 0;
                const frequencyText = $('input[name="contribution_frequency"]:checked').next('label').text();
                const years = $('#duration_years').val();
                const annualReturn = $('#annual_return_rate').val();

                summary.html(`
                    <p><strong>@lang('Initial Deposit'):</strong> <span>{{ gs('cur_sym') }}${deposit.toFixed(2)}</span></p>
                    <p><strong>@lang('Contribution Amount'):</strong> <span>{{ gs('cur_sym') }}${contribution.toFixed(2)}</span></p>
                    <p><strong>@lang('Contribution Frequency'):</strong> <span>${frequencyText}</span></p>
                    <p><strong>@lang('Duration'):</strong> <span>${years} @lang('Years')</span></p>
                    <p><strong>@lang('Annual Return Rate'):</strong> <span>${annualReturn}</span></p>
                `);
            });

        })(jQuery);
    </script>
@endpush
