@extends($activeTemplate . 'layouts.frontend')
@section('content')
    @php
        $contact = getContent('contact_us.content', true);
    @endphp

    <section class="contact-section py-100">
        <div class="container custom--container">
            <div class="row gy-4 gy-lg-0">
                <div class="col-sm-6 col-lg-4">
                    <div class="contact-info wow fadeInDown" data-wow-duration="0.5s" data-wow-delay="0.3s">
                        <div class="contact-info__icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                 fill="none">
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                      d="M3.29404 1.58612C4.25932 0.620833 5.88661 0.884906 6.49711 2.1059L8.5543 6.22028C8.93929 6.99026 8.78838 7.92021 8.17966 8.52893L4.86304 11.8455C6.35673 14.6391 8.6553 16.9376 11.4488 18.4313L14.7654 15.1147C15.3742 14.506 16.3041 14.3551 17.0741 14.7401L21.1885 16.7973C22.4095 17.4078 22.6735 19.035 21.7083 20.0003L20.2751 21.4335C19.7191 21.9895 18.9422 22.3313 18.1058 22.2912C8.86166 21.8476 1.44676 14.4327 1.00319 5.18854C0.963052 4.35216 1.30492 3.57524 1.86089 3.01927L3.29404 1.58612Z"
                                      fill="url(#paint0_linear_582_1984)"></path>
                                <defs>
                                    <linearGradient id="paint0_linear_582_1984" x1="11.6472" y1="1" x2="11.6472"
                                                    y2="22.2944" gradientUnits="userSpaceOnUse">
                                        <stop offset="1" stop-color="hsl(var(--base))"></stop>
                                        <stop offset="1" stop-color="#EF6315"></stop>
                                    </linearGradient>
                                </defs>
                            </svg>
                        </div>
                        <a class="contact-info__value"
                           href="tel:{{ $contact->data_values?->contact_number ?? '' }}">{{ $contact->data_values?->contact_number ?? '' }}</a>
                    </div>
                </div>
                <div class="col-sm-6 col-lg-4">
                    <div class="contact-info wow fadeInDown" data-wow-duration="0.5s" data-wow-delay="0.3s">
                        <div class="contact-info__icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                 fill="none">
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                      d="M1.25 6.16667C1.25 4.55584 2.56262 3.25 4.18182 3.25H19.8182C21.4374 3.25 22.75 4.55584 22.75 6.16667V17.8333C22.75 19.4442 21.4374 20.75 19.8182 20.75H4.18182C2.56262 20.75 1.25 19.4442 1.25 17.8333V6.16667ZM4.18182 18.8055C3.64208 18.8055 3.20454 18.3702 3.20454 17.8333V8.71191L10.6889 12.4347C11.5142 12.8453 12.4858 12.8453 13.3111 12.4347L20.7955 8.71191V17.8333C20.7955 18.3702 20.3579 18.8055 19.8182 18.8055H4.18182Z"
                                      fill="url(#paint0_linear_582_1992)"></path>
                                <defs>
                                    <linearGradient id="paint0_linear_582_1992" x1="12" y1="3.25" x2="12"
                                                    y2="20.75" gradientUnits="userSpaceOnUse">
                                        <stop offset="1" stop-color="hsl(var(--base))"></stop>
                                        <stop offset="1" stop-color="hsl(var(--base-two))"></stop>
                                    </linearGradient>
                                </defs>
                            </svg>
                        </div>
                        <a class="contact-info__value" href="mailto:{{ $contact->data_values?->email_address ?? '' }}">
                            {{ $contact->data_values?->email_address ?? '' }}
                        </a>
                    </div>
                </div>
                <div class="col-12 col-lg-4">
                    <div class="contact-info wow fadeInDown" data-wow-duration="0.5s" data-wow-delay="0.3s">
                        <div class="contact-info__icon">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                 xmlns="http://www.w3.org/2000/svg" class="injected-svg"
                                 data-src="https://cdn.hugeicons.com/icons/location-01-solid-standard.svg"
                                 xmlns:xlink="http://www.w3.org/1999/xlink" role="img" color="#000000">
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                      d="M11.6893 22.6825L11.6894 22.6826L11.6949 22.6851C11.8888 22.7713 12.1107 22.7715 12.3046 22.6854L12.3083 22.6837L12.3085 22.6836C12.3312 22.6732 12.3869 22.6477 12.4203 22.632C12.4913 22.5986 12.5934 22.5496 12.7221 22.4853C12.9794 22.3566 13.3438 22.1663 13.7797 21.9161C14.6496 21.4166 15.813 20.6738 16.9801 19.7012C19.2892 17.7769 21.75 14.8358 21.75 11C21.75 5.61522 17.3848 1.25 12 1.25C6.61522 1.25 2.25 5.61522 2.25 11C2.25 14.8358 4.71077 17.7769 7.01986 19.7012C8.18703 20.6738 9.35038 21.4166 10.2203 21.9161C10.6562 22.1663 11.0206 22.3566 11.2779 22.4853C11.4034 22.548 11.613 22.6466 11.6893 22.6825ZM12 7C9.79086 7 8 8.79086 8 11C8 13.2091 9.79086 15 12 15C14.2091 15 16 13.2091 16 11C16 8.79086 14.2091 7 12 7Z"
                                      fill="url(#paint0_linear_582_1992)"></path>

                                <defs>
                                    <linearGradient id="paint0_linear_582_1993" x1="12" y1="3.25" x2="12"
                                                    y2="20.75" gradientUnits="userSpaceOnUse">
                                        <stop offset="1" stop-color="hsl(var(--base))"></stop>
                                        <stop offset="1" stop-color="hsl(var(--base-two))"></stop>
                                    </linearGradient>
                                </defs>
                            </svg>
                        </div>
                        <p class="contact-info__value">
                            {{ __($contact->data_values?->contact_address ?? '') }}
                        </p>
                    </div>
                </div>
            </div>

            <div class="contact-card">
                <div class="row gy-4 gy-lg-0 flex-wrap-reverse">
                    <div class="col-lg-6 d-none d-lg-block">
                        <div class="contact-card-thumb wow fadeInLeft" data-wow-duration="0.5s" data-wow-delay="0.3s">
                            <img src="{{ frontendImage('contact_us', $contact->data_values?->image ?? '', '615x615') }}" alt="@lang('Image')">
                        </div>
                    </div>
                    <div class="col-md-12 col-lg-6">
                        <form class="contact-card-form wow fadeInRight" data-wow-duration="0.5s" data-wow-delay="0.3s" method="post" class="verify-gcaptcha">
                            @csrf
                            <h1 class="contact-card-title">@lang('Lets Get in touch')</h1>
                            <div class="row gy-4">
                                <div class="col-sm-6">
                                    <label class="form--label required">@lang('Name')</label>
                                    <div class="form--control-wrapper">
                                        <input type="text" name="name" class="form--control"
                                               placeholder="@lang('Full name')" value="{{ old('name', $user?->fullname) }}"
                                               @if ($user && $user->profile_complete) readonly @endif required>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <label class="form--label required">@lang('Email')</label>
                                    <div class="form--control-wrapper">
                                        <input type="email" name="email" class="form--control"
                                               placeholder="@lang('Email address')" value="{{ old('email', $user?->email) }}"
                                               @if ($user) readonly @endif required>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <label class="form--label required">@lang('Subject')</label>
                                    <div class="form--control-wrapper">
                                        <input type="text" name="subject" class="form--control"
                                               placeholder="@lang('Subject')" value="{{ old('subject') }}" required>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <label class=" form--label required">@lang('Message')</label>
                                    <div class="form--control-wrapper form--control-wrapper-textarea">
                                        <textarea name="message" class="form--control" placeholder="@lang('Message')" required>{{ old('message') }}</textarea>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <x-captcha isFrontend="true" />
                                    <button class="w-100 btn btn--lg btn--base mt-1" type="submit">
                                        @lang('Send Message')
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>

    @if (isset($sections->secs) && $sections->secs != null)
        @foreach (json_decode($sections->secs) as $sec)
            @include($activeTemplate . 'sections.' . $sec)
        @endforeach
    @endif
@endsection
