@extends($activeTemplate . 'layouts.frontend')
@section('content')
    <section class="blog-detials py-120">
        <div class="container">
            <div class="row gy-5 ">
                <div class="col-lg-8">
                    <div class="blog-details">
                        <div class="blog-details__thumb">
                            <img src="{{ frontendImage('blog', $blog?->data_values?->image, '860x490') }}" class="fit-image"
                                 alt="@lang('blog-details')">
                        </div>
                        <div class="blog-details__content">
                            <h3 class="blog-details__title">{{ __($blog->data_values?->title) }}</h3>

                            <p>@lang('Published At') : {{ showDateTime($blog->created_at, 'd M Y') }}</p>

                            <p class="blog-details__desc">
                                @php echo $blog->data_values?->description @endphp
                            </p>

                            <div class="share-btn d-flex gap-3 flex-wrap align-items-center mt-4">
                                <h6 class="share-btn__title mb-0">@lang('Share This:')</h6>
                                <ul class="social-list">
                                    <li class="social-list__item"><a
                                           href="https://www.facebook.com/sharer/sharer.php?u={{ urlencode(url()->current()) }}"
                                           class="social-list__link flex-center" target="_blank"><i
                                               class="fab fa-facebook-f"></i></a>
                                    </li>
                                    <li class="social-list__item"><a
                                           href="https://twitter.com/intent/tweet?url={{ urlencode(url()->current()) }}&text={{ urlencode($blog->title) }}"
                                           class="social-list__link flex-center" target="_blank"> <i
                                               class="fab fa-twitter"></i></a>
                                    </li>
                                    <li class="social-list__item"><a
                                           href="https://www.linkedin.com/shareArticle?mini=true&url={{ urlencode(url()->current()) }}&title={{ urlencode($blog->title) }}"
                                           class="social-list__link flex-center" target="_blank"> <i
                                               class="fab fa-linkedin-in"></i></a>
                                    </li>
                                    <li class="social-list__item"><a
                                           href="https://pinterest.com/pin/create/button/?url={{ urlencode(url()->current()) }}&media={{ urlencode(getImage('assets/images/frontend/blog/thumb_' . $blog->data_values?->image ?? '', '495x405')) }}&description={{ urlencode($blog->title) }}"
                                           class="social-list__link flex-center" target="_blank"> <i
                                               class="fab fa-pinterest"></i></a>
                                    </li>
                                </ul>
                            </div>

                        </div>
                    </div>
                    <div class="fb-comments" data-href="{{ url()->current() }}" data-numposts="5"></div>
                </div>
                <div class="col-lg-4">
                    <div class="blog-sidebar-wrapper">
                        <div class="blog-sidebar">
                            <h5 class="blog-sidebar__title"> @lang('Latest Blogs') </h5>
                            @foreach ($latests as $latest)
                                <div class="latest-blog">
                                    <div class="latest-blog__thumb">
                                        <a href="{{ route('blog.details', $latest->slug) }}">
                                            <img src="{{ frontendImage('blog', 'thumb_' . $latest->data_values?->image ?? '', '430x245') }}" class="fit-image" alt="@lang('blog-details')"></a>
                                    </div>
                                    <div class="latest-blog__content">
                                        <h6 class="latest-blog__title">
                                            <a href="{{ route('blog.details', $latest->slug) }}">{{ __(strLimit($latest->data_values?->title ?? '', 15)) }}</a>
                                        </h6>
                                        <p class="latest-blog__desc">@php echo __(strLimit(strip_tags($latest->data_values?->description ?? ''), 30)) @endphp</p>
                                        <span class="latest-blog__date fs-13">{{ showDateTime($latest->created_at, 'd M Y') }}</span>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@push('fbComment')
    @php echo loadExtension('fb-comment') @endphp
@endpush
