<div class="row">
    @foreach ($formData as $data)
            <div class="col-md-{{ (isset($data->width) && $data->width) ? $data->width : '12' }}">
            <div class="form-group">
                <label class="form-label">{{ __($data->name) }} @if(isset($data->instruction) && $data->instruction) <span data-bs-toggle="tooltip" title="{{ __($data->instruction) }}"><i class="fas fa-info-circle"></i></span> @endif @if($data->is_required == 'required' && ($data->type == 'checkbox' || $data->type == 'radio')) <span class="text--danger">*</span> @endif </label>
                @if ($data->type == 'text')
                    <div class="form--control-wrapper">
                        <input type="text" class="form--control" name="{{ $data->label }}"
                            value="{{ old($data->label) }}" @if ($data->is_required == 'required') required @endif>
                    </div>
                @elseif($data->type == 'url')
                    <div class="form--control-wrapper">
                        <input type="url" class="form--control" name="{{ $data->label }}"
                            value="{{ old($data->label) }}" @if ($data->is_required == 'required') required @endif>
                    </div>
                @elseif($data->type == 'email')
                    <div class="form--control-wrapper">
                        <input type="email" class="form--control" name="{{ $data->label }}"
                            value="{{ old($data->label) }}" @if ($data->is_required == 'required') required @endif>
                    </div>
                @elseif($data->type == 'datetime')
                    <div class="form--control-wrapper">
                        <input type="datetime-local" class="form--control" name="{{ $data->label }}"
                            value="{{ old($data->label) }}" @if ($data->is_required == 'required') required @endif>
                    </div>
                @elseif($data->type == 'date')
                    <div class="form--control-wrapper">
                        <input type="date" class="form--control" name="{{ $data->label }}"
                            value="{{ old($data->label) }}" @if ($data->is_required == 'required') required @endif>
                    </div>
                @elseif($data->type == 'time')
                    <div class="form--control-wrapper">
                        <input type="time" class="form--control" name="{{ $data->label }}"
                            value="{{ old($data->label) }}" @if ($data->is_required == 'required') required @endif>
                    </div>
                @elseif($data->type == 'number')
                    <div class="form--control-wrapper">
                        <input type="number" class="form--control" name="{{ $data->label }}"
                            value="{{ old($data->label) }}" step="any"
                            @if ($data->is_required == 'required') required @endif>
                    </div>
                @elseif($data->type == 'textarea')
                    <div class="form--control-wrapper form--control-wrapper-textarea">
                        <textarea class="form--control" name="{{ $data->label }}" @if ($data->is_required == 'required') required @endif>{{ old($data->label) }}</textarea>
                    </div>
                @elseif($data->type == 'select')
                    <div class="form--select2-wrapper">
                        <span class="form--select2-wrapper__shapes"></span>
                        <select class="form-select form--control select2" data-minimum-results-for-search="-1"
                            name="{{ $data->label }}" @if ($data->is_required == 'required') required @endif>
                            <option value="">@lang('Select One')</option>
                            @foreach ($data->options as $item)
                                <option value="{{ $item }}" @selected($item == old($data->label))>{{ __($item) }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                @elseif($data->type == 'checkbox')
                    <div class="d-flex gap-3 flex-wrap">
                        @foreach ($data->options as $option)
                            <div class="form-check">
                                <input class="form-check-input" name="{{ $data->label }}[]" type="checkbox"
                                    value="{{ $option }}" id="{{ $data->label }}_{{ titleToKey($option) }}">
                                <label class="form-check-label"
                                    for="{{ $data->label }}_{{ titleToKey($option) }}">{{ $option }}</label>
                            </div>
                        @endforeach
                    </div>
                    <div class="checkbox-required-error text--danger"></div>
                @elseif($data->type == 'radio')
                    <div class="d-flex gap-3 flex-wrap">
                        @foreach ($data->options as $option)
                            <div class="form-check">
                                <input class="form-check-input" name="{{ $data->label }}" type="radio"
                                    value="{{ $option }}" id="{{ $data->label }}_{{ titleToKey($option) }}"
                                    @checked($option == old($data->label))>
                                <label class="form-check-label"
                                    for="{{ $data->label }}_{{ titleToKey($option) }}">{{ $option }}</label>
                            </div>
                        @endforeach
                    </div>
                @elseif($data->type == 'file')
                    <div class="form--control-wrapper">
                        <input type="file" class="form--control" name="{{ $data->label }}"
                            @if ($data->is_required == 'required') required @endif
                            accept="@foreach (explode(',', $data->extensions) as $ext) .{{ $ext }}, @endforeach">
                    </div>
                    <pre class="text--base mt-1">@lang('Supported mimes'): {{ $data->extensions }}</pre>
                @endif
            </div>
        </div>
    @endforeach
</div>
@push('script')
    <script>
        const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]')
        const tooltipList = [...tooltipTriggerList].map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl))
    </script>
@endpush
