@extends('admin.layouts.app')

@section('panel')
    <div class="row gy-4 mt-2">
        <div class="col-xxl-3 col-sm-6">
            <x-widget style="7" link="{{ route('admin.investment.all') }}" title="Total Investments"
                      icon="las la-wallet" value="{{ $investments['total_investment_count'] }}" bg="18" type="2" />
        </div><!-- dashboard-w1 end -->
        <div class="col-xxl-3 col-sm-6">
            <x-widget style="7" link="{{ route('admin.report.contribution') }}" title="Total Contributions"
                      icon="fa-solid fa-hand-holding-dollar" value="{{ showAmount($investments['total_contribution_amount']) }}"
                      bg="12" type="2" />
        </div><!-- dashboard-w1 end -->
        <div class="col-xxl-3 col-sm-6">
            <x-widget style="7" link="{{ route('admin.investment.requests.close') }}"
                      title="Investment Close Requests" icon="fas fa-hand-paper"
                      value="{{ $investments['total_close_requests'] }}" bg="danger" type="2" />
        </div><!-- dashboard-w1 end -->
        <div class="col-xxl-3 col-sm-6">
            <x-widget style="7" link="{{ route('admin.investment.completed') }}" title="Completed Investments"
                      icon="fa fa-check-circle" value="{{ $investments['completed_investment'] }}" bg="primary"
                      type="2" />
        </div><!-- dashboard-w1 end -->
    </div>

    <div class="row mb-none-30 mt-30">
        <div class="col-xl-6 mb-30">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex flex-wrap justify-content-between">
                        <h5 class="card-title">@lang('Investment Report')</h5>
                        <div id="investmentDatePicker" class="border p-1 cursor-pointer rounded">
                            <i class="la la-calendar"></i>&nbsp;
                            <span></span> <i class="la la-caret-down"></i>
                        </div>
                    </div>
                    <div id="investmentChartArea"></div>
                </div>
            </div>
        </div>
        <div class="col-xl-6 mb-30">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex flex-wrap justify-content-between">
                        <h5 class="card-title">@lang('Contribution Report')</h5>
                        <div id="contributionDatePicker" class="border p-1 cursor-pointer rounded">
                            <i class="la la-calendar"></i>&nbsp;
                            <span></span> <i class="la la-caret-down"></i>
                        </div>
                    </div>
                    <div id="contributionChartArea"></div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('script-lib')
    <script src="{{ asset('assets/admin/js/vendor/apexcharts.min.js') }}"></script>
    <script src="{{ asset('assets/admin/js/vendor/chart.js.2.8.0.js') }}"></script>
    <script src="{{ asset('assets/admin/js/moment.min.js') }}"></script>
    <script src="{{ asset('assets/admin/js/daterangepicker.min.js') }}"></script>
    <script src="{{ asset('assets/admin/js/charts.js') }}"></script>
@endpush

@push('style-lib')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/admin/css/daterangepicker.css') }}">
@endpush

@push('script')
    <script>
        "use strict";

        const start = moment().subtract(14, 'days');
        const end = moment();

        const dateRangeOptions = {
            startDate: start,
            endDate: end,
            ranges: {
                'Today': [moment(), moment()],
                'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                'Last 15 Days': [moment().subtract(14, 'days'), moment()],
                'Last 30 Days': [moment().subtract(30, 'days'), moment()],
                'This Month': [moment().startOf('month'), moment().endOf('month')],
                'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf(
                    'month')],
                'Last 6 Months': [moment().subtract(6, 'months').startOf('month'), moment().endOf('month')],
                'This Year': [moment().startOf('year'), moment().endOf('year')],
            },
            maxDate: moment()
        }

        const changeDatePickerText = (element, startDate, endDate) => {
            $(element).html(startDate.format('MMMM D, YYYY') + ' - ' + endDate.format('MMMM D, YYYY'));
        }

        let investmentChart = barChart(
            document.querySelector("#investmentChartArea"),
            "Quantity",
            [{
                name: 'New Investments',
                data: []
            }],
            [],
        );

        let contributionChart = lineChart(
            document.querySelector("#contributionChartArea"),
            [{
                name: "Contribution Amount",
                data: []
            }],
            []
        );

        const fetchInvestmentChart = (startDate, endDate) => {

            const data = {
                start_date: startDate.format('YYYY-MM-DD'),
                end_date: endDate.format('YYYY-MM-DD')
            }

            const url = `{{ route('admin.invest.report.chart.investment') }}`;

            $.get(url, data,
                function(response, status) {
                    if (status == 'success') {
                        investmentChart.updateSeries(response.data);
                        investmentChart.updateOptions({
                            xaxis: {
                                categories: response.created_on,
                            }
                        });
                    }
                }
            );
        }

        const fetchContributionChart = (startDate, endDate) => {
            const data = {
                start_date: startDate.format('YYYY-MM-DD'),
                end_date: endDate.format('YYYY-MM-DD')
            }

            const url = `{{ route('admin.invest.report.chart.contribution') }}`;

            $.get(url, data, function(data, status) {
                if (status == 'success') {
                    contributionChart.updateSeries(data.data);
                    contributionChart.updateOptions({
                        xaxis: {
                            categories: data.created_on,
                        }
                    });
                }
            });
        }

        $('#investmentDatePicker').daterangepicker(dateRangeOptions, (start, end) => changeDatePickerText(
            '#investmentDatePicker span',
            start, end));

        $('#contributionDatePicker').daterangepicker(dateRangeOptions, (start, end) => changeDatePickerText(
            '#contributionDatePicker span', start, end));

        $('#dwDatePicker').daterangepicker(dateRangeOptions, (start, end) => changeDatePickerText('#dwDatePicker span',
            start, end));
        $('#trxDatePicker').daterangepicker(dateRangeOptions, (start, end) => changeDatePickerText('#trxDatePicker span',
            start, end));

        changeDatePickerText('#investmentDatePicker span', start, end);
        changeDatePickerText('#contributionDatePicker span', start, end);
        changeDatePickerText('#dwDatePicker span', start, end);
        changeDatePickerText('#trxDatePicker span', start, end);

        fetchInvestmentChart(start, end);
        fetchContributionChart(start, end);
        depositWithdrawChart(start, end);
        transactionChart(start, end);

        $('#investmentDatePicker').on('apply.daterangepicker', (event, picker) => fetchInvestmentChart(picker.startDate,
            picker.endDate));

        $('#contributionDatePicker').on('apply.daterangepicker', (event, picker) => fetchContributionChart(picker.startDate,
            picker.endDate));

        $('#dwDatePicker').on('apply.daterangepicker', (event, picker) => depositWithdrawChart(picker.startDate, picker
            .endDate));
        $('#trxDatePicker').on('apply.daterangepicker', (event, picker) => transactionChart(picker.startDate, picker
            .endDate));
    </script>
@endpush
@push('style')
    <style>
        .apexcharts-menu {
            min-width: 120px !important;
        }
    </style>
@endpush
