@extends('admin.layouts.app')
@section('panel')
    <div class="row mb-none-30">
        <div class="col-lg-12 col-md-12 mb-30">
            <div class="card">
                <div class="card-body">
                    <form method="POST">
                        @csrf
                        <div class="row">
                            <div class="col-xl-4 col-sm-6">
                                <div class="form-group ">
                                    <label> @lang('Annual Return Rate')</label>
                                    <div class="input-group">
                                        <input class="form-control" type="number" name="annual_return_rate" required
                                            value="{{ getAmount(gs('annual_return_rate')) }}" min="0">
                                        <span class="input-group-text">%</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-4 col-sm-6">
                                <div class="form-group ">
                                    <label> @lang('Minimum Year of Investment')</label>
                                    <input class="form-control" type="text" name="investment_minimum_year" required
                                        value="{{ getAmount(gs('investment_minimum_year')) }}">
                                </div>
                            </div>
                            <div class="col-xl-4 col-sm-6">
                                <div class="form-group ">
                                    <label> @lang('Maximum Year of Investment')</label>
                                    <input class="form-control" type="text" name="investment_maximum_year" required
                                        value="{{ getAmount(gs('investment_maximum_year')) }}">
                                </div>
                            </div>
                            <div class="form-group col-xl-4 col-sm-6">
                                <label> @lang('Late Contribution Penalty Frequency')</label>
                                <select class="select2 form-control" name="penalty_frequency"
                                    data-minimum-results-for-search="-1">
                                    <option value="1" @selected(gs('penalty_frequency') == Status::DAILY_FREQUENCY)>@lang('Daily')</option>
                                    <option value="2" @selected(gs('penalty_frequency') == Status::WEEKLY_FREQUENCY)>@lang('Weekly')</option>
                                    <option value="3" @selected(gs('penalty_frequency') == Status::MONTHLY_FREQUENCY)>@lang('Monthly')</option>
                                    <option value="4" @selected(gs('penalty_frequency') == Status::ANNUALLY_FREQUENCY)>@lang('Yearly')</option>
                                </select>
                            </div>
                            <div class="col-xl-4 col-sm-6">
                                <div class="form-group">
                                    <label> @lang('Late Contribution Penalty')</label>
                                    <div class="input-group">
                                        <select class="form-control" name="penalty_type" required>
                                            <option value="{{ Status::PENALTY_TYPE_PERCENT }}"
                                                {{ gs('penalty_type') == Status::PENALTY_TYPE_PERCENT ? 'selected' : '' }}>
                                                @lang('Percent')
                                            </option>
                                            <option value="{{ Status::PENALTY_TYPE_FIXED }}"
                                                {{ gs('penalty_type') == Status::PENALTY_TYPE_FIXED ? 'selected' : '' }}>
                                                @lang('Fixed')
                                            </option>
                                        </select>
                                        <input class="form-control" type="text" name="contribution_penalty" required
                                            value="{{ getAmount(gs('contribution_penalty')) }}">
                                        <span class="input-group-text" id="penalty-symbol">
                                            {{ gs('penalty_type') == Status::PENALTY_TYPE_PERCENT ? '%' : gs('cur_text') }}
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-4 col-sm-6">
                                <div class="form-group ">
                                    <label> @lang('Penalty For Early Closer')</label>
                                    <div class="input-group">
                                        <input class="form-control" type="number" name="early_closure_penalty" required
                                            value="{{ getAmount(gs('early_closure_penalty')) }}" min="0">
                                        <span class="input-group-text">%</span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <button type="submit" class="btn btn--primary w-100 h-45">@lang('Submit')</button>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('script')
    <script>
        (function($) {
            "use strict";

            $('select[name="penalty_type"]').on('change', function() {
                var symbol = $('#penalty-symbol');
                var currencyText = '{{ gs('cur_text') }}';
                var penaltyTypePercent = '{{ Status::PENALTY_TYPE_PERCENT }}';

                if ($(this).val() === penaltyTypePercent) {
                    symbol.text('%');
                } else {
                    symbol.text(currencyText);
                }
            });

        })(jQuery);
    </script>
@endpush
