@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th>@lang('TRX/Created At')</th>
                                    <th>@lang('User')</th>
                                    <th>@lang('Initial Deposit')</th>
                                    <th>@lang('Contribution Amount')</th>
                                    <th>@lang('Total Return')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($investments as $investment)
                                    <tr>
                                        <td>
                                            <span class="fw-bold">{{ $investment->trx }}</span>
                                            <br>
                                            <small class="text-muted">{{ showDateTime($investment->created_at) }}</small>
                                        </td>
                                        <td>
                                            <span class="d-block">{{ __($investment->user?->fullname ?? null) }}</span>
                                            <span>
                                                <a class="text--primary"
                                                    href="{{ route('admin.users.detail', $investment->user_id ?? null) }}">
                                                    <span
                                                        class="text--primary">@</span>{{ __($investment->user?->username ?? null) }}
                                                </a>
                                            </span>
                                        </td>
                                        <td>
                                            {{ showAmount($investment->initial_deposit) }}
                                        </td>

                                        <td>
                                            {{ showAmount($investment->contribution_amount) }}
                                        </td>

                                        <td>
                                            {{ showAmount($investment->total_return) }}
                                        </td>
                                        <td> @php echo $investment->investStatusBadgeData() @endphp </td>
                                        <td>
                                            <div class="button--group">
                                                <a href="{{ route('admin.investment.details', $investment->id) }}"
                                                    class="btn btn-sm btn-outline--primary">
                                                    <i class="las la-desktop"></i>@lang('Details')</a>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="100%" class="text-muted text-center">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
                @if ($investments->hasPages())
                    <div class="card-footer py-4">
                        {{ paginateLinks($investments) }}
                    </div>
                @endif

            </div>
        </div>
    </div>
@endsection

@push('breadcrumb-plugins')
    <x-search-form placeholder="Transaction Id, Username" dateSearch='yes' />
@endpush
