<?php

namespace App\Models;

use App\Constants\Status;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Model;

class Investment extends Model {
    public function user() {
        return $this->belongsTo(User::class);
    }

    public function contributions() {
        return $this->hasMany(Contribution::class);
    }

    public function scopeActive($query) {
        return $query->where("status", Status::INVESTMENT_ACTIVE);
    }
    public function scopeCompleted($query) {
        return $query->where("status", Status::INVESTMENT_COMPLETE);
    }
    public function scopeClosed($query) {
        return $query->where("status", Status::INVESTMENT_CLOSED);
    }

    public function scopeCloseRequest($query) {
        return $query->where("close_request", Status::YES);
    }

    public function investStatusBadge(): Attribute {
        return new Attribute(
            get: fn() => $this->investStatusBadgeData(),
        );
    }

    public function investStatusBadgeData() {
        $html = '';
        if ($this->status == Status::INVESTMENT_ACTIVE) {
            $html = '<span class="badge custom--badge badge--primary">' . trans('Active') . '</span>';
        } else if ($this->status == Status::INVESTMENT_COMPLETE) {
            $html = '<span class="badge custom--badge badge--success">' . trans('Completed') . '</span>';
        } else if ($this->status == Status::INVESTMENT_CLOSED) {
            $html = '<span class="badge custom--badge badge--warning">' . trans('Closed') . '</span>';
        } else if ($this->status == Status::INVESTMENT_INITIATE) {
            $html = '<span class="badge custom--badge badge--info">' . trans('Initiated') . '</span>';
        } else if ($this->status == Status::INVESTMENT_REJECTED) {
            $html = '<span class="badge custom--badge badge--danger">' . trans('Rejected') . '</span>';
        }
        return $html;
    }
}
