@extends('layouts.dash')
@section('title', $title)
@section('content')

    <!-- Page title -->
    <div class="page-title mt-5 mb-3 my-md-5">
        <div class="row justify-content-between align-items-center">
            <div class="mb-3 col-md-6 mb-md-0">
                <h5 class="mb-0 text-white h3 font-weight-400">Hello, {{ Auth::user()->name }}!</h5>
            </div>
        </div>
    </div>
    <x-danger-alert />
    <x-success-alert />
    <x-pay-alert />
    @if (!empty($settings->welcome_message) and Auth::user()->created_at->diffInDays() <= 3)
        <div class="row">
            <div class="col-12">
                <div class="py-4 alert alert-primary alert-dismissible fade show" role="alert">
                    {{ $settings->welcome_message }}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            </div>
        </div>
    @endif
    @if ($settings->enable_annoc == 'on' and !empty($settings->newupdate))
        <div class="row">
            <div class="col-12">
                <div class="py-4 alert alert-info alert-dismissible fade show" role="alert">
                    {{ $settings->newupdate }}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            </div>
        </div>
    @endif

    <div class="row">
         <div class="col-md-4">
            <div class="p-3 card shadow border" >
                <div class="">
                    <div>
                        <small class="text-muted" style="font-size:0.7rem !important">ACCOUNT BALANCE</small>
                        <h1 class="mb-1 text-" style="font-size:2rem !important"><b>{{ Auth::user()->currency }}{{ number_format(Auth::user()->account_bal, 2, '.', ',') }}</b></h1>
                    </div>
                </div>
                <div class="row mt-4">
                    <div class="col-12">
                          <!--TradingView Widget BEGIN -->
                        <div class="tradingview-widget-container ">
                          <div id="tradingview_3eb3f"></div>
                          <script type="text/javascript" src="https://s3.tradingview.com/tv.js"></script>
                          <script type="text/javascript">
                          new TradingView.widget(
                          {
                          "width": "100%",
                          "height": 275,
                          "symbol": "NASDAQ:AAPL",
                          "interval": "W",
                          "timezone": "Etc/UTC",
                          "theme": "dark",
                      "isTransparent": true,
                          "style": "3",
                          "locale": "en",
                          "toolbar_bg": "#f1f3f6",
                          "enable_publishing": false,
                          "hide_top_toolbar": true,
                          "hide_legend": true,
                          "save_image": false,
                          "container_id": "tradingview_3eb3f"
                        }
                          );
                          </script>
                        </div>
                         <!--TradingView Widget END -->
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-8">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <!--<div class="col-12">-->
                        <!--    <div class="nk-block-head-content">-->
                        <!--        <h5 class="text-primary h5">Account Summary</h5>-->
                        <!--    </div>-->
                        <!--</div>-->
                        
                        
                          @if(Auth::user()->bonus >0)
                        <div class=" col-md-6">
                            <div class="card card-stats">
                                <!-- Card body -->
                                <div class="card-body bg-primary">
                                    <div class="row">
                                        <div class="col">
                                            <h6 class="mb-1  text-white">Tax Fee</h6>
                                            <span
                                                class="mb-0 h5 font-weight-bold text-white">{{ Auth::user()->currency }}{{ number_format(Auth::user()->bonus, 2, '.', ',') }}</span>
                                        </div>
                                        <div class="col-auto">
                                            <div class="text-white icon bg-gradient-primary rounded-circle icon-shape">
                                                <i class="fas fa-gift"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endif
                         @if(Auth::user()->action =='Yes')
                        <div class=" col-md-6">
                            <div class="card card-stats">
                                <!-- Card body -->
                                <div class="card-body bg-warning">
                                    <div class="row">
                                        <div class="col">
                                            <h6 class="mb-1  text-white">Upgrade Fee {{Auth::user()->currency}}{{Auth::user()->amount}}</h6>
                                          
                                            
                                        </div>
                                        <div class="col-auto">
                                            <div class="text-white icon bg-gradient-primary rounded-circle icon-shape">
                                                <i class="fas fa-level-up"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endif
                         @if(Auth::user()->signalstatus =='Yes')
                        <div class="col-xl-4 col-md-6">
                            <div class="card card-stats">
                                <!-- Card body -->
                                <div class="card-body bg-success">
                                    <div class="row">
                                        <div class="col">
                                            <h6 class="mb-1  text-white">{{Auth::user()->signalname}} Signal Payment</h6>
                                            <h6 class="mb-1  text-white">YOU ARE REQUIRED TO PAY FOR {{Auth::user()->signalname}}-{{Auth::user()->signalamount}}{{Auth::user()->currency}}  </h6>
                                            <p> <a href="{{ route('deposits') }}" class='btn btn-warning'>Pay Now</a></p>
                                            
                                            
                                        </div>
                                        <div class="col-auto">
                                            <div class="text-white icon bg-gradient-primary rounded-circle icon-shape">
                                                <i class="fas fa-level-up"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endif
                        <!--<div class="col-xl-4 col-md-6">-->
                        <!--    <div class="card card-stats">-->
                        <!--        <div class="card-body">-->
                        <!--            <div class="row">-->
                        <!--                <div class="col">-->
                        <!--                    <h6 class="mb-1 text-muted">Account balance</h6>-->
                        <!--                    <span-->
                        <!--                        class="mb-0 h5 font-weight-bold">{{ Auth::user()->currency }}{{ number_format(Auth::user()->account_bal, 2, '.', ',') }}</span>-->
                        <!--                </div>-->
                        <!--                <div class="col-auto">-->
                        <!--                    <div class="text-white icon bg-gradient-primary rounded-circle icon-shape">-->
                        <!--                        <i class="fas fa-sack-dollar"></i>-->
                        <!--                    </div>-->
                        <!--                </div>-->
                        <!--            </div>-->
                        <!--        </div>-->
                        <!--    </div>-->
                        <!--</div>-->
                        @if ($mod['investment'])
                            <div class=" col-md-6">
                                <div class="card card-stats">
                                    <!-- Card body -->
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col">
                                                <h6 class="mb-1 text-muted">Total Profit</h6>
                                                <span
                                                    class="mb-0 h5 font-weight-bold">{{ Auth::user()->currency }}{{ number_format(Auth::user()->roi, 2, '.', ',') }}</span>
                                            </div>
                                            <div class="col-auto">
                                                <div class="text-white icon bg-gradient-success rounded-circle icon-shape">
                                                    <i class="fas fa-coins"></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif
                        <!--<div class="col-xl-4 col-md-6">-->
                        <!--    <div class="card card-stats">-->
                                <!-- Card body -->
                        <!--        <div class="card-body">-->
                        <!--            <div class="row">-->
                        <!--                <div class="col">-->
                        <!--                    <h6 class="mb-1 text-muted">Bonus</h6>-->
                        <!--                    <span-->
                        <!--                        class="mb-0 h5 font-weight-bold">{{ Auth::user()->currency }}{{ number_format(Auth::user()->bonus, 2, '.', ',') }}</span>-->
                        <!--                </div>-->
                        <!--                <div class="col-auto">-->
                        <!--                    <div class="text-white icon bg-gradient-primary rounded-circle icon-shape">-->
                        <!--                        <i class="fas fa-gift"></i>-->
                        <!--                    </div>-->
                        <!--                </div>-->
                        <!--            </div>-->
                        <!--        </div>-->
                        <!--    </div>-->
                        <!--</div>-->

                        <!--@if ($mod['subscription'])-->
                        <!--    <div class="col-xl-4 col-md-6">-->
                        <!--        <div class="card card-stats">-->
                                    <!-- Card body -->
                        <!--            <div class="card-body">-->
                        <!--                <div class="row">-->
                        <!--                    <div class="col">-->
                        <!--                        <h6 class="mb-1 text-muted">Trading Accounts</h6>-->
                        <!--                        <span class="mb-0 h5 font-weight-bold">{{ $trading_accounts }}</span>-->
                        <!--                    </div>-->
                        <!--                    <div class="col-auto">-->
                        <!--                        <div class="text-white icon bg-gradient-primary rounded-circle icon-shape">-->
                        <!--                            <i class="fas fa-th-list"></i>-->
                        <!--                        </div>-->
                        <!--                    </div>-->
                        <!--                </div>-->
                        <!--            </div>-->
                        <!--        </div>-->
                        <!--    </div>-->
                        <!--@endif-->
                        <!--<div class="col-xl-4 col-md-6">-->
                        <!--    <div class="card card-stats">-->
                                <!-- Card body -->
                        <!--        <div class="card-body">-->
                        <!--            <div class="row">-->
                        <!--                <div class="col">-->
                        <!--                    <h6 class="mb-1 text-muted">Referral Bonus</h6>-->
                        <!--                    <span-->
                        <!--                        class="mb-0 h5 font-weight-bold">{{ Auth::user()->currency }}{{ number_format(Auth::user()->ref_bonus, 2, '.', ',') }}</span>-->
                        <!--                </div>-->
                        <!--                <div class="col-auto">-->
                        <!--                    <div class="text-white icon bg-gradient-primary rounded-circle icon-shape">-->
                        <!--                        <i class="fas fa-gifts"></i>-->
                        <!--                    </div>-->
                        <!--                </div>-->
                        <!--            </div>-->
                        <!--        </div>-->
                        <!--    </div>-->
                        <!--</div>-->
                        <div class=" col-md-6">
                            <div class="card card-stats">
                                <!-- Card body -->
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col">
                                            <h6 class="mb-1 text-muted">Total Deposit</h6>
                                            <span class="mb-0 h5 font-weight-bold">
                                                <p
                                                    class="mb-0 h5 font-weight-bold ">{{ Auth::user()->currency }}{{ number_format($deposited, 2, '.', ',') }}
                                                </p>
                                            </span>
                                        </div>
                                        <div class="col-auto">
                                            <div class="text-white icon bg-gradient-warning rounded-circle icon-shape">
                                                <i class="fas fa-arrow-alt-circle-down"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!--@if ($mod['investment'] || $mod['cryptoswap'])-->
                        <!--    <div class="col-xl-4 col-md-6">-->
                        <!--        <div class="card card-stats">-->
                                    <!-- Card body -->
                        <!--            <div class="card-body">-->
                        <!--                <div class="row">-->
                        <!--                    <div class="col">-->
                        <!--                        <h6 class="mb-1 text-muted">Total Withdrawal</h6>-->
                        <!--                        <span class="mb-0 h5 font-weight-bold">-->
                        <!--                            {{ Auth::user()->currency }}{{ number_format($total_withdrawal, 2, '.', ',') }}-->
                        <!--                        </span>-->
                        <!--                    </div>-->
                        <!--                    <div class="col-auto">-->
                        <!--                        <div class="text-white icon bg-gradient-primary rounded-circle icon-shape">-->
                        <!--                            <i class="fas fa-arrow-circle-up"></i>-->
                        <!--                        </div>-->
                        <!--                    </div>-->
                        <!--                </div>-->
                        <!--            </div>-->
                        <!--        </div>-->
                        <!--    </div>-->
                        <!--@endif-->
                    </div>
                    
                    

               @if ($mod['investment'])
{{-- Active Investment plans section --}}
<div class="mt-3 mt-md-5 row">
    <div class="col-12 mb-2">
        <div class="nk-block-head-content">
          
            <h5 class="text-primary h5">Active AI Trading <span
                    class="text-base count">({{ $plans ? count($plans) : '0' }})</span></h5>
                     <p style="font-size:0.8rem" class="mb-1">Make your money work for you and earn profits by investing in our world-class auto-trading AI.</p>
        </div>
    </div>
    <div class="col-12">
        @forelse ($plans as $plan)
            <div class="row">
                <div class="col-md-12">
                    <div class="py-4 card">
                        <div class="card-body d-flex justify-content-between align-items-center">

                            <div class="">
                                <h6 class="text-black h6">{{ $plan->dplan->name }}</h6>
                                <p class="text-muted">Amount - <span
                                        class="amount">{{ Auth::user()->currency }}{{ number_format($plan->amount) }}</span>
                                </p>
                            </div>
                            <div class="d-none d-md-block">
                                <div class="d-flex justify-content-around">
                                    <div class="mr-3">
                                        <h6 class="text-black bold">
                                            {{ $plan->created_at->toDayDateTimeString() }}
                                        </h6>
                                        <span class="nk-iv-scheme-value date">Start Date</span>
                                    </div>
                                    <i class="fas fa-arrow-right text-muted"></i>
                                    <div class="ml-3">
                                        <h6 class="text-black bold">
                                            {{ \Carbon\Carbon::parse($plan->expire_date)->toDayDateTimeString() }}
                                        </h6>
                                        <span class="nk-iv-scheme-value date">End Date</span>
                                    </div>
                                </div>
                            </div>

                            <div>
                                <h6 class="text-black">
                                    @if ($plan->active == 'yes')
                                        <span class="badge badge-success">Active</span>
                                    @elseif($plan->active == 'expired')
                                        <span class="badge badge-danger">Expired</span>
                                    @else
                                        <span class="badge badge-danger">Inactive</span>
                                    @endif
                                </h6>
                                <span class="nk-iv-scheme-value amount">Status</span>
                            </div>

                            <a href="{{ route('plandetails', $plan->id) }}">
                                <i class="fas fa-chevron-right fa-2x"></i>
                            </a>
                        </div>
                    </div>
                </div>

            </div>

        @empty
            <div class=" row">
                <div class="col-md-12 shadow-none">
                    <div class="py-4 card">
                        <div class="text-center card-body py-3">
                            <p>You do not have an active investment plan at the moment.</p>
                            <a href="{{ route('mplans') }}" class="px-3 btn btn-primary">Buy a
                                plan</a>
                        </div>
                    </div>
                </div>
            </div>
        @endforelse
        <!--@if (count($plans) > 0)-->
        <!--    <div class="text-right">-->
        <!--        <a href="{{ route('myplans', 'yes') }}"> <i class="fas fa-archive"></i> Go to my-->
        <!--            plans</a>-->
        <!--    </div>-->
        <!--@endif-->
    </div>
</div>
{{-- end of active investmet and purchase of investment plan --}}
@endif

                  
        </div>
        
        
    </div>
    </div>
    </div>
    
<!--secon part-->
<!--<wideget --1 starts></wideget>-->
<div class="row">
        <div class="col-12">
            <div class="p-3 card shadow border">
                <div class="row">
                    <!--<div class="col-12">-->
                    <!--    <div class="nk-block-head-content">-->
                    <!--        <h5 class="text-primary h5">Market Overview</h5>-->
                    <!--    </div>-->
                    <!--</div>-->
                    <div class="col-12">
                        <!-- TradingView Widget BEGIN -->
                        <div class="tradingview-widget-container">
                          <div class="tradingview-widget-container__widget"></div>
                          <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-market-overview.js" async>
                          {
                          "colorTheme": "dark",
                          "dateRange": "12M",
                          "showChart": false,
                          "locale": "en",
                          "largeChartUrl": "",
                          "isTransparent": true,
                          "showSymbolLogo": true,
                          "showFloatingTooltip": false,
                          "width": "100%",
                          "height": 380,
                          "tabs": [
                            {
                              "title": "Crypto",
                              "symbols": [
                                {
                                  "s": "BINANCE:BTCUSDT"
                                },
                                {
                                  "s": "BINANCE:ETHUSDT"
                                },
                                {
                                  "s": "BINANCE:LTCUSDT"
                                },
                                {
                                  "s": "BINANCE:DOGEUSDT"
                                },
                                {
                                  "s": "BINANCE:XRPUSDT"
                                },
                                {
                                  "s": "BINANCE:TRXUSDT"
                                }
                              ],
                              "originalTitle": "Indices"
                            }
                          ]
                        }
                          </script>
                        </div>
                        <!-- TradingView Widget END -->
                    </div>
                </div>
            </div>
        </div> 
        </div>
        <!--widget ----1 ends-->

 <div class="row">
        
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
    

{{-- 10 Recent transaction begin --}}
<div class="mt-4 row">
<div class="col-12">
    <div class="nk-block-head-content">
        <h6 class="text-primary h5">Recent transactions <span
                class="text-base count">({{ count($t_history) }})</span>
        </h6>
    </div>
</div>
 <ul class="mb-3 nav nav-pills nav-pills-icon nav-justified" id="pills-tab" role="tablist">
                        <li class="pr-2" role="presentation">
                            <a class="nav-link active" id="pills-home-tab" data-toggle="pill" href="{{ route('deposits') }}" role="tab"
                                aria-controls="pills-home" aria-selected="true">
                                <span class="d-block text-sm">Deposit</span>
                            </a>
                        </li>
                        <li class="px-2" role="presentation">
                            <a class="nav-link" id="pills-profile-tab" data-toggle="pill" href="{{ route('withdrawalsdeposits') }}"
                                role="tab" aria-controls="pills-profile" aria-selected="false">
                                <span class="d-block text-sm">Withdrawal</span>
                            </a>
                        </li>
                        <!--<li class="p-2 nav-item" role="presentation">-->
                        <!--    <a class="nav-link" id="pills-contact-tab" data-toggle="pill" href="#pills-contact"-->
                        <!--        role="tab" aria-controls="pills-contact" aria-selected="false">-->
                        <!--        <span class="d-block">Others</span>-->
                        <!--    </a>-->
                        <!--</li>-->
                    </ul>
<div class="col-12">
    <div class="card">
        <div class="card-body">
            <div class="mb-2 text-right">
                <a href="{{ route('accounthistory') }}"> <i class="fas fa-clipboard"></i> View
                    all
                    transactions</a>
            </div>
            <div class="table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr class="bg-light">
                            <th>Date</th>
                            <th>Type</th>
                            <th>Amount</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($t_history as $item)
                            <tr>
                                <td>
                                    {{ $item->created_at->toDayDateTimeString() }}
                                </td>
                                <td>
                                    {{ $item->type }}
                                </td>
                                <td>
                                    <span class="badge badge-success">
                                        {{ Auth::user()->currency }}{{ number_format($item->amount) }}</span>
                                </td>
                            </tr>
                        @empty
                            <td colspan="3">
                                No record yet
                            </td>
                        @endforelse

                    </tbody>
                </table>
            </div>
        </div>
    </div>

</div>
</div>
{{-- end of recent transactions --}}

<div class="mt-4 row">
<div class="col-md-12">
    <div class="card">
        <div class="card-body">
            <h5 class="text-black">Refer Us & Earn</h5>
            <p>Use the below link to invite your friends.</p>
            <div class="mb-3 input-group">
                <input type="text" class="form-control myInput readonly"
                    value="{{ Auth::user()->ref_link }}" id="reflink" readonly>
                <div class="input-group-append">
                    <button class="btn btn-outline-success" onclick="myFunction()"
                        type="button">
                        <i class="fas fa-copy"></i>
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>
</div>
<div class="mt-4 row">
<div class="col-md-12">
    <div class="card">
        <div class="card-body">
            <h5 class="text-black">Live Market Data</h5>
            @include('includes.chart')
            </div>
        </div>
    </div>
</div>
</div>
</div>
</div>
                  
        </div>
        
        
    </div>
    </div>
    </div>
@endsection
